\name{Sorting of the columns-rows of a matrix}
\alias{sort_mat}
\title{
Sorting of the columns-rows of a matrix 
}

\description{
Fast sorting of the columns-rows of a matrix.
}

\usage{
sort_mat(x, by.row = FALSE, descending = FALSE, stable = FALSE)
}

\arguments{
\item{x}{
A numerical matrix with data.
}
\item{by.row}{
If you want to sort the rows of the matrix set this to TRUE.
}
\item{descending}{
If you want the sorting in descending order, set this to TRUE.
}
\item{stable}{
If you the stable version, so that the results are the same as R's (in the case of ties) set this to TRUE.
If this is TRUE, the algorithm is a bit slower.
}
}

%\details{
%
%}

\value{
The matrix with its columns-rows (or rows) independently sorted.
}

%\references{
%Shabalin, A.A. (2012). Matrix eQTL: Ultra fast eQTL analysis %via large matrix operations. Bioinformatics 28(10): 1353-1358.
%}

\author{
Manos Papadakis

R implementation and documentation: Manos Papadakis <papadakm95@gmail.com>.
}

%\note{
  %%  ~~further notes~~
    %}

\seealso{
\code{\link{nth}, \link{colMaxs}, \link{colMins}, \link{colrange}, \link{sort_cor_vectors}, 
\link{sort_index}, \link{sort_unique}
}
}

\examples{
x <- matrix( rnorm(100 * 500), ncol = 500 )
system.time( s1 <- sort_mat(x) )
system.time( s2 <- apply(x, 2, sort)  )
all.equal(as.vector(s1), as.vector(s2))
}

\keyword{ Sorting }


