% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imp.rfnode.cond.R
\name{imp.rfnode.cond}
\alias{imp.rfnode.cond}
\title{Perform multiple imputation based on the conditional distribution formed by
prediction nodes of random forests}
\usage{
imp.rfnode.cond(
  data,
  num.imp = 5,
  max.iter = 5,
  num.trees = 10,
  pre.boot = TRUE,
  print.flag = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame or a matrix containing the incomplete data. Missing
values should be coded as \code{NA}s.}

\item{num.imp}{Number of multiple imputations. The default is
\code{num.imp = 5}.}

\item{max.iter}{Number of iterations. The default is \code{max.iter = 5}.}

\item{num.trees}{Number of trees to build. The default is
\code{num.trees = 10}.}

\item{pre.boot}{If \code{TRUE}, bootstrapping prior to imputation will be
performed to perform 'proper' multiple imputation, for accommodating sampling
variation in estimating population regression parameters
(see Shah et al. 2014).
It should be noted that if \code{TRUE}, this option is in effect even if the
number of trees is set to one.}

\item{print.flag}{If \code{TRUE}, details will be sent to console. The
default is \code{print.flag = FALSE}.}

\item{...}{Other arguments to pass down.}
}
\value{
An object of S3 class \code{mids}.
}
\description{
\code{RfEmpImp} multiple imputation method for mixed types of variables,
using conditional distribution formed by predicting nodes of random forest
(out-of-bag observations will be excluded).
}
\details{
\code{imp.rfnode.cond} multiple imputation, for missing observations, the
non-missing observations used for imputation will be found by the observations
included in the predicting nodes in the random trees.
}
\examples{
# Prepare data: convert categorical variables to factors
nhanes.fix <- nhanes
nhanes.fix[, c("age", "hyp")] <- lapply(nhanes[, c("age", "hyp")], as.factor)
# Perform imputation using imp.rfnode.cond
imp <- imp.rfnode.cond(nhanes.fix)
# Do repeated analyses
anl <- with(imp, lm(chl ~ bmi + hyp))
# Pool the results
pool <- pool(anl)
# Get pooled estimates
reg.ests(pool)

}
\references{
Hong, Shangzhi, et al. "Multiple imputation using chained random forests."
Preprint, submitted April 30, 2020. https://arxiv.org/abs/2004.14823.

Zhang, Haozhe, et al. "Random Forest Prediction Intervals."
The American Statistician (2019): 1-20.

Shah, Anoop D., et al. "Comparison of random forest and parametric
imputation models for imputing missing data using MICE: a CALIBER study."
American journal of epidemiology 179.6 (2014): 764-774.

Malley, James D., et al. "Probability machines." Methods of information
in medicine 51.01 (2012): 74-81.
}
\author{
Shangzhi Hong
}
