% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateCooperationIndex.R
\name{Interactions}
\alias{Interactions}
\alias{competitionIndex}
\alias{complementarityIndex}
\title{Calculating the species interactions}
\usage{
complementarityIndex(g1, g2, seed.set1, seed.set2, threshold = 0, p = FALSE,
  nperm = 1000)

competitionIndex(g1, g2, seed.set1, seed.set2, threshold = 0, p = FALSE,
  nperm = 1000)
}
\arguments{
\item{g1, }{igraph object, a species-specific metabolic network.}

\item{g2, }{igraph object, a species-specific metabolic network, the complementary
network of g1}

\item{seed.set1, }{seeds slot of a seed-set object, seeds of the metabolic 
network g1, more details see \code{\link{seedset-class}}.}

\item{seed.set2, }{seeds slot of a seed-set object, seeds of the metabolic 
network g2, more details see \code{\link{seedset-class}}.}

\item{threshold, }{the cutoff of confidence score to be serve as a seed set, 
default is 0.}

\item{p, }{a logical value which determins whether the calculated index is 
statistical or biological significant. default is FALSE.}

\item{nperm, }{the number of permuations of metabolic network node labes, which
is used for complementarity index's P value calculating, default is 1000.}
}
\value{
a two length list: complementarity index or competition index: range 
from 0 to 1, p value of complementarity index. Or a single value of 
complementarity or competition index while p is FALSE.
}
\description{
Calculating the metabolic complementarity index and complementarity index of 
based on species metabolic network.
}
\details{
Metabolic competition index is defined as the fraction of compounds 
in a species seed set of metabolic network that are also included in its partner; 
However, metabolic complementarity index is the fraction of compounds in one 
species seed set of metabolic network appearing in the metabolic network but 
not in the seed set of its partner. However, seed compounds are associated 
with a confidence score (1/size of SCC), so this fraction is calculated as a 
normalized weighted sum.

Based on the metabolic network and seed sets of species, this functions help 
us to predict the species interactions of species1 on the presence of species2.
}
\examples{
\dontrun{
## metabolic network reconstruction and seed set identity of sample data anno.species
net <- lapply(anno.species,reconstructGsMN)
seed.sets <- lapply(net, getSeedSets) 
seed.sets <- lapply(seed.sets, function(x)x@seeds)

## calculate the complementarity index of the first species
complementarity.index <- complementarityIndex(net[[1]],net[[2]], 
 seed.sets[[1]], seed.sets[[2]])
competition.index <- competitionIndex(net[[1]],net[[2]], 
 seed.sets[[1]], seed.sets[[2]])
}
}
\seealso{
\code{\link{getSeedSets}},
\code{\link{calculateCooperationIndex}}
}

