#' Annotation profiles of seven well-studied oral species
#' 
#' A dataset containing the the KEGG orthology annotation profiles of seven oral
#' species which was downloaded from the Integrated Microbial Genomes (IMG).
#' 
#' @details This datasets constains the KEGG orthology annotation information of
#'   seven oral species whose interactions were carefully and well
#'   characterized. The human oral microbiota is relatively  #' well described.
#'   The name of these seven species is: \emph{Aggregatibacter}, 
#'   \emph{actinomycetemcomitans D7S-1}, \emph{Fusobacterium nucleatum
#'   polymorphum ATCC 10953}, \emph{Porphyromonas gingivalis ATCC 33277},
#'   \emph{Streptococcus gordonii str. Challis substr. CH1},
#'   \emph{Streptococcus oralis SK23, ATCC 35037}, \emph{Veillonella atypica
#'   ACS-134-V-Col7a}. For more annotation information on these species, see
#'   \url{img.jgi.doe.gov/}.
 
#' \itemize{
#'   \item Aa, Aggregatibacter actinomycetemcomitans D7S-1
#'   \item Ao, Actinomyces oris K20
#'   \item Fn, Fusobacterium nucleatum polymorphum ATCC 10953
#'   \item Pg, Porphyromonas gingivalis ATCC 33277
#'   \item Sg, Streptococcus gordonii str. Challis substr. CH1
#'   \item So, Streptococcus oralis SK23, ATCC 35037
#'   \item Va, Veillonella atypica ACS-134-V-Col7a  
#' }
#'
#' @format A list with seven elements and each elements represents the annotation profile of the species
#' 
#' @source \url{img.jgi.doe.gov/}
#' 
#' @name anno.species
NULL