% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HTTPDate.R
\docType{class}
\name{HTTPDate-class}
\alias{HTTPDate-class}
\title{HTTP Date class}
\arguments{
\item{from}{\code{numeric}, \code{POSIXct} or \code{HTTPDate} object.}
}
\description{
Conversions between POSIXct to HTTP Date objects.
}
\examples{
# convert POSIXct to HTTP date string
as(0, "HTTPDate") # Thu, 01 Jan 1970 00:00:00 GMT
as(Sys.time(), "HTTPDate")
# parse HTTP date string to POSIXct
dt = "Thu, 01 Jan 1970 00:00:00 GMT"
class(dt) = "HTTPDate"
as(dt, "POSIXct")
}
\references{
\href{https://tools.ietf.org/html/rfc7231#section-7.1.1.1}{RFC7231}
\href{https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Date}{MDN}
}
