% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuthBackendBearer.R
\docType{data}
\name{AuthBackendBearer}
\alias{AuthBackendBearer}
\title{Bearer token authorization backend}
\format{\link[R6:R6Class]{R6::R6Class} object.}
\description{
Creates AuthBackendBearer class object.
}
\section{Construction}{
\preformatted{AuthBackendBearer$new(FUN)
}
\itemize{
\item \code{FUN} :: \code{function}\cr
\code{character(1)} -> \code{logical(1)} \cr
Function to perform authentication which takes one arguments - \code{token}.
Returns boolean - whether access is allowed for a requested \code{token} or not.
}
}

\section{Methods}{

\itemize{
\item \code{authenticate(request, response)}\cr
\link{Request}, \link{Response} -> \code{NULL}\cr
Provide authentication for the given request.
}
}

\examples{

token_db = list(
  "valid-token" = as.POSIXct("2099-12-31", tz = "GMT"),
  "expired-token" = as.POSIXct("1900-01-01", tz = "GMT")
)
auth_fun = function(token) {
  if (is.null(token_db[[token]])) return(FALSE) # not found
  if (Sys.time() > token_db[[token]]) return(FALSE) # expired
  return(TRUE)
}
# init backend
auth_backend = AuthBackendBearer$new(FUN = auth_fun)

# test backend
# define credentials (see RFC)
token = "valid-token"
# generate request headers
h = list("Authorization" = sprintf("Bearer \%s", token))
# simulate request
rq = Request$new(path = "/", headers = h)
# init response object
rs = Response$new()
# perform authentication
auth_backend$authenticate(rq, rs) # TRUE

}
\references{
\href{https://tools.ietf.org/html/rfc6750}{RFC6750}
\href{https://swagger.io/docs/specification/authentication/bearer-authentication}{Specification}
}
\seealso{
\link{AuthMiddleware} \link{Request} \link{Response}

Other AuthBackend: \code{\link{AuthBackendBasic}},
  \code{\link{AuthBackend}}, \code{\link{AuthMiddleware}}
}
\concept{AuthBackend}
\keyword{datasets}
