/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common;

import org.apache.sanselan.common.RationalNumber;

public abstract class RationalNumberUtilities
extends Number {
    private static final double TOLERANCE = 1.0E-8;

    public static final RationalNumber getRationalNumber(double value) {
        RationalNumber h;
        RationalNumber l;
        int approx;
        if (value >= 2.147483647E9) {
            return new RationalNumber(Integer.MAX_VALUE, 1);
        }
        if (value <= -2.147483647E9) {
            return new RationalNumber(-2147483647, 1);
        }
        boolean negative = false;
        if (value < 0.0) {
            negative = true;
            value = Math.abs(value);
        }
        if (value == 0.0) {
            return new RationalNumber(0, 1);
        }
        if (value >= 1.0) {
            approx = (int)value;
            if ((double)approx < value) {
                l = new RationalNumber(approx, 1);
                h = new RationalNumber(approx + 1, 1);
            } else {
                l = new RationalNumber(approx - 1, 1);
                h = new RationalNumber(approx, 1);
            }
        } else {
            approx = (int)(1.0 / value);
            if (1.0 / (double)approx < value) {
                l = new RationalNumber(1, approx);
                h = new RationalNumber(1, approx - 1);
            } else {
                l = new RationalNumber(1, approx + 1);
                h = new RationalNumber(1, approx);
            }
        }
        Option low = Option.factory(l, value);
        Option high = Option.factory(h, value);
        Option bestOption = low.error < high.error ? low : high;
        int MAX_ITERATIONS = 100;
        for (int count = 0; bestOption.error > 1.0E-8 && count < 100; ++count) {
            RationalNumber mediant = RationalNumber.factoryMethod((long)low.rationalNumber.numerator + (long)high.rationalNumber.numerator, (long)low.rationalNumber.divisor + (long)high.rationalNumber.divisor);
            Option mediantOption = Option.factory(mediant, value);
            if (value < mediant.doubleValue()) {
                if (high.error <= mediantOption.error) break;
                high = mediantOption;
            } else {
                if (low.error <= mediantOption.error) break;
                low = mediantOption;
            }
            if (!(mediantOption.error < bestOption.error)) continue;
            bestOption = mediantOption;
        }
        return negative ? bestOption.rationalNumber.negate() : bestOption.rationalNumber;
    }

    private static class Option {
        public final RationalNumber rationalNumber;
        public final double error;

        private Option(RationalNumber rationalNumber, double error) {
            this.rationalNumber = rationalNumber;
            this.error = error;
        }

        public static final Option factory(RationalNumber rationalNumber, double value) {
            return new Option(rationalNumber, Math.abs(rationalNumber.doubleValue() - value));
        }

        public String toString() {
            return this.rationalNumber.toString();
        }
    }
}

