/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.pptx4r.elements.template;

import org.docx4j.dml.CTTextListStyle;
import org.docx4j.dml.CTTransform2D;
import org.lysis.reporters.tools.Debug;
import org.pptx4j.pml.Shape;

public class ShapeDescription {
    private long idx;
    private CTTransform2D xfrm = null;
    private String shapeType = "undefined";
    private boolean islist = false;
    private CTTextListStyle listStyle;
    private Shape shape;

    public ShapeDescription(Shape s) {
        this.shape = s;
        try {
            this.shapeType = s.getNvSpPr().getNvPr().getPh().getType().value();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.listStyle = s.getTxBody().getLstStyle();
            this.islist = true;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.idx = s.getNvSpPr().getNvPr().getPh().getIdx();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.xfrm = s.getSpPr().getXfrm();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setIdx(long _idx) {
        this.idx = _idx;
    }

    public boolean isList() {
        return this.islist;
    }

    public CTTextListStyle getListStyle() {
        return this.listStyle;
    }

    public long getIdx() {
        return this.idx;
    }

    public boolean hasXfrm() {
        return this.xfrm != null;
    }

    public CTTransform2D getXfrm() throws NullPointerException {
        if (Debug.doc_explorer) {
            System.err.println("shape description - getXfrm => rotate: " + this.xfrm.getRot());
        }
        if (this.xfrm == null) {
            throw new NullPointerException("No Xfrm defined");
        }
        return this.xfrm;
    }

    public int[] getDimensions() {
        int[] data = new int[4];
        Long offx = new Long(this.xfrm.getOff().getX());
        Long offy = new Long(this.xfrm.getOff().getY());
        Long extx = new Long(this.xfrm.getExt().getCx());
        Long exty = new Long(this.xfrm.getExt().getCy());
        data[0] = offx.intValue();
        data[1] = offy.intValue();
        data[2] = extx.intValue();
        data[3] = exty.intValue();
        return data;
    }

    public void setXfrm(CTTransform2D _xfrm) {
        if (Debug.doc_explorer) {
            System.err.println("shape description - setXfrm => rotate arg: " + _xfrm.getRot());
        }
        this.xfrm = _xfrm;
    }

    public String getShapeType() {
        return this.shapeType;
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean isContent() {
        return this.getShapeType().equals("body") || this.getShapeType().equals("obj") || this.getShapeType().equals("title") || this.getShapeType().equals("pic") || this.getShapeType().equals("tbl") || this.getShapeType().equals("subTitle") || this.getShapeType().equals("dt") || this.getShapeType().equals("sldNum") || this.getShapeType().equals("ftr");
    }

    public String toString() {
        return "type=" + this.shapeType + "\t{offx:" + this.xfrm.getOff().getX() + ",offy:" + this.xfrm.getOff().getY() + ",extx:" + this.xfrm.getExt().getCx() + ",exty:" + this.xfrm.getExt().getCy() + "}";
    }
}

