% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FlexTablePublicAPI.R
\name{spanFlexTableRows}
\alias{spanFlexTableRows}
\title{Span rows within columns}
\usage{
spanFlexTableRows(object, j, from, to, runs)
}
\arguments{
\item{object}{a \code{FlexTable} object}

\item{j}{vector (integer index, col.names values or boolean vector) for columns selection.}

\item{from}{index of the first row to span (its content will be the visible one).}

\item{to}{index of the last row to span.}

\item{runs}{a vector of size \code{numrow} of FlexTable. If provided, successive
runs of equal values will indicate to merge corresponding rows.}
}
\description{
Span rows within columns.
}
\note{
Overlappings of horizontally merged cells and vertically merged cells are forbidden.
}
\examples{
#
mydata = iris[46:55, ]
MyFTable = FlexTable( data = mydata )

# merge line 5 to 7 in column 1
MyFTable = spanFlexTableRows( MyFTable, j = 3, from = 5, to = 7 )

# merge cells in column "Species" when successive values 
# of Species are identical. Note 
# the character vector length is the same 
# than the number of lines of the FlexTable.
MyFTable = spanFlexTableRows( MyFTable, j = "Species", 
  runs = as.character( mydata$Species ) )
}
\seealso{
\code{\link{FlexTable}}, \code{\link{spanFlexTableColumns}}
}

