% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addCodeBlock.bsdoc.R
\name{addCodeBlock.bsdoc}
\alias{addCodeBlock.bsdoc}
\title{Add a code block into a bsdoc object}
\usage{
\method{addCodeBlock}{bsdoc}(doc, file, text,
  par.properties = parProperties(), text.properties = textProperties(color =
  "#A7947D"), ...)
}
\arguments{
\item{doc}{\code{\link{bsdoc}} object where expressions have to be added}

\item{file}{file. Not used if text is provided.}

\item{text}{character vector. The text to parse. Not used if file is provided.}

\item{par.properties}{code block paragraph properties. An object of class \code{\link{parProperties}}}

\item{text.properties}{code block text properties. An object of class \code{\link{textProperties}}}

\item{...}{further arguments, not used.}
}
\value{
an object of class \code{\link{bsdoc}}.
}
\description{
Add a code block into a \code{\link{bsdoc}} object.
}
\examples{
\dontrun{
doc.filename = "addCodeBlock/example.html"

# set default font size to 11
options( "ReporteRs-fontsize" = 11 )

doc = bsdoc( )
doc = addCodeBlock( doc, text = "ls -a\\nwhich -a ls" )

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{bsdoc}}, \code{\link{addCodeBlock}}
}

