/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.img;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.Sanselan;

public class Imageutils {
    public static byte[] convertImageToByteArray(File file) throws FileNotFoundException, IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            System.out.println("File too large!!");
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            System.out.println("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static int[] getDimensions(byte[] image_bytes) throws Exception {
        int[] out = new int[4];
        ImageInfo imageInfo = Sanselan.getImageInfo((byte[])image_bytes);
        int physicalWidthDpi = imageInfo.getPhysicalWidthDpi();
        int physicalHeightDpi = imageInfo.getPhysicalHeightDpi();
        if (physicalWidthDpi < 1 || physicalHeightDpi < 1) {
            System.err.println("can not read dpi, assuming 96 dpi.");
        }
        if (physicalWidthDpi < 1 || physicalHeightDpi < 1) {
            physicalWidthDpi = 96;
            physicalHeightDpi = 96;
        }
        out[0] = imageInfo.getWidth();
        out[1] = imageInfo.getHeight();
        out[2] = physicalWidthDpi;
        out[3] = physicalHeightDpi;
        return out;
    }
}

