/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.tables;

import java.util.LinkedHashMap;
import org.docx4j.dml.CTTableRow;
import org.docx4j.wml.Tr;
import org.lysis.reporters.html4r.elements.HTML4R;
import org.lysis.reporters.tables.FlexCell;

public class FlexRow
implements HTML4R {
    private LinkedHashMap<Integer, FlexCell> cellList = new LinkedHashMap();
    private int index = 0;

    public void add(FlexCell fc) {
        ++this.index;
        this.cellList.put(this.index, fc);
    }

    public void add(FlexCell fc, int i) {
        this.cellList.put(i, fc);
    }

    public int size() {
        return this.index;
    }

    public int weight() {
        int out = 0;
        if (this.index > 0) {
            int i = 1;
            while (i < this.index + 1) {
                out += this.cellList.get(i).getColspan();
                ++i;
            }
        }
        return out;
    }

    public FlexCell getCell(int index) {
        return this.cellList.get(index);
    }

    public String toString() {
        String out = "";
        if (this.index > 0) {
            int i = 1;
            while (i < this.index + 1) {
                out = String.valueOf(out) + this.cellList.get(i).toString();
                ++i;
            }
        }
        return out;
    }

    @Override
    public String getHTML() {
        String out = "<tr>";
        int i = 1;
        while (i <= this.index) {
            out = String.valueOf(out) + this.cellList.get(i).getHTML();
            ++i;
        }
        out = String.valueOf(out) + "</tr>";
        return out;
    }

    public Tr getTr() {
        Tr workingRow = new Tr();
        int i = 1;
        while (i <= this.index) {
            workingRow.getContent().add(this.cellList.get(i).getTc());
            ++i;
        }
        return workingRow;
    }

    public CTTableRow getCTTableRow() throws Exception {
        CTTableRow workingRow = new CTTableRow();
        int i = 1;
        while (i <= this.index) {
            FlexCell temp = this.cellList.get(i);
            workingRow.getTc().add(temp.getCTTableCell());
            if (temp.getColspan() > 1) {
                int p = 1;
                while (p < temp.getColspan()) {
                    FlexCell temp1 = temp.clone();
                    temp1.setColspan(0);
                    workingRow.getTc().add(temp1.getCTTableCell());
                    ++p;
                }
            }
            ++i;
        }
        return workingRow;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

