% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtotal_dupe_removal.R
\name{subtotal_dupe_removal}
\alias{subtotal_dupe_removal}
\title{Duplicate Subtotal Row Removal Function}
\usage{
subtotal_dupe_removal(
  data,
  column,
  iterator = 2,
  skip = 0,
  remove = "All",
  suffix = "_Default_Suffix"
)
}
\arguments{
\item{data}{Data frame or tibble to remove duplicate row labels from.}

\item{column}{Column containing duplicate row labels.}

\item{iterator}{Minimum number of rows meant to be between each section. Usually two.}

\item{skip}{Number of rows to skip removing rows from. Usually zero. Can be used to dodge NA values.}

\item{remove}{Label of subtotals to be removed. Usually "All".}

\item{suffix}{Suffix to disambiguate required column name if already taken.}
}
\value{
The data report without duplicate subtotal rows.
}
\description{
Removes duplicate subtotal rows,
which may be created by totalling a variable with only one level.
In tables with many variables, some may have only one level within one section and many in other sections.
}
\details{
Adds a leading version of the requested column,
which places each observation in the same row as the next observation.
Usually the observation 2 rows on - determined by the iterator.
From here if both the original and leading column equal the value to be removed,
then the row is a duplicate subtotal and is removed.
Note: the last few rows will have NA values in the leading column, so they are covered separately.
Note: If you already have columns named Lead or Index, they receive a temporary suffix.
}
\examples{
library(dplyr)

group_by(mtcars, cyl, vs) \%>\% summarise(sum(wt), .groups = "keep") \%>\%
subtotal_row(mtcars, "wt") \%>\%
subtotal_dupe_removal(2)
group_by(mtcars, cyl, vs, am) \%>\% summarise(mean(hp), .groups = "keep") \%>\%
subtotal_row(mtcars, "hp", "mean") \%>\%
subtotal_dupe_removal(3, skip = 1)
group_by(mtcars, cyl, vs, am) \%>\% summarise(mean(hp), .groups = "keep") \%>\%
subtotal_row(mtcars, "hp", "mean") \%>\%
subtotal_dupe_removal(3, skip = 1)
}
