% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/UpdateFieldName.R
\name{UpdateFieldName}
\alias{UpdateFieldName}
\title{Rename a field in a BibEntry object.}
\usage{
UpdateFieldName(x, old.field, new.field)
}
\arguments{
\item{x}{- a BibEntry object}

\item{old.field}{- string; the current name of the field to be renamed}

\item{new.field}{- string; the new name to replace \code{old.field}}
}
\value{
\code{x}, with the renamed field.
}
\description{
This function will rename a field, in every entry where it is present, in a
BibEntry object.
}
\examples{
bib <- as.BibEntry(list(c(bibtype = "article", key = "mclean2014a", title = "My New Article",
  author = "Mathew W. McLean", journal = "The Journal", date = "2014-01"),
  c(bibtype = "article", key = "mclean2014b", title = "My Newer Article",
    author = "Mathew W. McLean", journal = "The Journal", date = "2014-02")))
bib <- UpdateFieldName(bib, "journal", "journaltitle")
toBiblatex(bib)
}
\keyword{manip}
\keyword{utilities}

