% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.plot.R
\name{p.plot}
\alias{p.plot}
\title{Probabilities of Record Plots}
\usage{
p.plot(
  X,
  plot = c("1", "2", "3"),
  record = c(FU = 1, FL = 1, BU = 1, BL = 1),
  point.col = c(FU = "red", FL = "blue", BU = "red", BL = "blue"),
  point.shape = c(FU = 19, FL = 19, BU = 4, BL = 4),
  conf.int = TRUE,
  conf.level = 0.9,
  conf.aes = c("ribbon", "errorbar"),
  conf.col = "grey69",
  smooth = TRUE,
  smooth.formula = y ~ x,
  smooth.method = stats::lm,
  smooth.weight = TRUE,
  smooth.linetype = c(FU = 1, FL = 1, BU = 2, BL = 2),
  ...
)
}
\arguments{
\item{X}{A numeric vector, matrix (or data frame).}

\item{plot}{One of the values "1", "2" or "3" (character or numeric class 
are both allowed). It determines the type of plot to be displayed (see 
Details).}

\item{record}{Logical vector. Vector with four elements indicating if 
forward upper, forward lower, backward upper and backward lower are going
to be shown, respectively. Logical values or 0,1 values are accepted.}

\item{point.col, point.shape}{Vector with four elements indicating the colour
and shape of the points. Every one of the four elements represents forward
upper, forward lower, backward upper and backward lower, respectively.}

\item{conf.int}{Logical. Indicates if the CIs are also shown.}

\item{conf.level}{(If \code{conf.int == TRUE}) Confidence level of the CIs.}

\item{conf.aes}{(If \code{conf.int == TRUE}) A character string indicating 
the aesthetic to display for the CIs, \code{"ribbon"} (grey area) or 
\code{"errorbar"} (vertical lines).}

\item{conf.col}{Colour used to plot the expected value and (if 
\code{conf.int == TRUE}) CIs.}

\item{smooth}{(If \code{plot = 1} or \code{3}) Logical. If \code{TRUE}, a
smoothing in the probabilities is also plotted.}

\item{smooth.formula}{(\code{smooth = TRUE}) \code{\link{formula}} to use 
in the smooth function, e.g., \code{y ~ x}, 
\code{y ~ poly(x, 2, raw = TRUE)}, \code{y ~ log(x)}.}

\item{smooth.method}{(If \code{smooth = TRUE}) Smoothing method (function) 
to use, e.g., \code{\link{lm}} or \code{\link{loess}}.}

\item{smooth.weight}{(If \code{smooth = TRUE}) Logical. If \code{TRUE} 
(the default) the smoothing is estimated with weights.}

\item{smooth.linetype}{(If \code{smooth = TRUE}) Vector with four elements 
indicating the line type of the smoothing. Every one of the four elements
represents forward upper, forward lower, backward upper and backward
lower, respectively.}

\item{...}{Further arguments to pass through the smooth 
(see \code{ggplot2::geom_smooth}).}
}
\value{
A ggplot object.
}
\description{
This function builds a ggplot object to display different 
  functions of the record probabilities at time \eqn{t}, \eqn{p_t}.
  A graphical tool to study the hypothesis of the classical record model 
  (i.e., of IID continuous RVs).
}
\details{
Three different types of plots which aim to analyse the hypothesis
  of the classical record model using the record probabilities are 
  implemented. Estimations of the record probabilities \eqn{\hat p_t} used
  in the plots are obtained as the proportion of records at time \eqn{t}
  in \eqn{M} vectors (columns of matrix \code{X}) (see 
  \code{\link{p.record}}).

  Type 1 is the plot of the observed values \eqn{t \hat p_t} versus time 
  \eqn{t} (see \code{\link{p.regression.test}} for its associated test and
  details). 
  The expected values under the classical record model are \eqn{1} for any
  value \eqn{t}, so that a cloud of points around \eqn{1} and with no trend
  should be expected. The estimated values are plotted, together with 
  binomial confidence intervals (CIs). In addition, a smoothing function
  can be fitted to the cloud of points.
  
  Type 2 is the plot of the estimated record probabilities \eqn{p_t} versus
  time \eqn{t}. The expected probabilities under the classical record model, 
  \eqn{p_t=1/t}, are also plotted, together with binomial CIs. 
  
  Type 3 is the same plot but on a logarithmic scale, so that the
  expected value is \eqn{-\log(t)}. In this case, another smoothing 
  function can be fitted to the cloud of points.
  
  Type 1 plot was proposed by Cebrián, Castillo-Mateo, Asín (2021), while 
  type 2 and 3 appear in Benestad (2003, Figures 8 and 9, 2004, Figure 4).
}
\examples{
# three plots available
p.plot(ZaragozaSeries, plot = 1)
p.plot(ZaragozaSeries, plot = 2)
p.plot(ZaragozaSeries, plot = 3)

# Posible fits (plot 1):
#fit a line
p.plot(ZaragozaSeries, record = c(1,0,0,0))
# fit a second order polynomial
p.plot(ZaragozaSeries, record = c(1,0,0,0), 
  smooth.formula = y ~ poly(x, degree = 2))
# force the line to pass by E(t*p_t) = 1 when t = 1, i.e., E(t*p_t) = 1 + beta_1 * (t-1)
p.plot(ZaragozaSeries, record = c(1,0,0,0), 
  smooth.formula = y ~ I(x-1) - 1 + offset(rep(1, length(x))))
# force the second order polynomial pass by E(t*p_t) = 1 when t = 1
p.plot(ZaragozaSeries, record = c(1,0,0,0), 
  smooth.formula = y ~ I(x-1) + I(x^2-1) - 1 + offset(rep(1, length(x))))
# fit a loess
p.plot(ZaragozaSeries, record = c(1,0,0,0), 
  smooth.method = stats::loess, span = 0.25)
}
\references{
Benestad RE (2003). 
“How Often Can We Expect a Record Event?” 
\emph{Climate Research}, \strong{25}(1), 3–13.

Benestad RE (2004). 
“Record-Values, Nonstationarity Tests and Extreme Value Distributions.” 
\emph{Global and Planetary Change}, \strong{44}(1–4), 11–26. 

Cebrián A, Castillo-Mateo J and Asín J (2021).
“Record Tests to Detect Non Stationarity in the Tails with an Application to Climate Change.”
Available at Research Square \doi{10.21203/rs.3.rs-214787/v1}
}
\seealso{
\code{\link{p.regression.test}}
}
\author{
Jorge Castillo-Mateo
}
