/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Date;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.SystemEventListenerFactory;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.InternalWorkingMemory;
import org.drools.time.AcceptsTimerJobFactoryManager;
import org.drools.time.InternalSchedulerService;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.SessionPseudoClock;
import org.drools.time.TimerService;
import org.drools.time.Trigger;
import org.drools.time.impl.DefaultJobHandle;
import org.drools.time.impl.DefaultTimerJobFactoryManager;
import org.drools.time.impl.TimerJobFactoryManager;
import org.drools.time.impl.TimerJobInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoClockScheduler
implements TimerService,
SessionPseudoClock,
Externalizable,
InternalSchedulerService,
AcceptsTimerJobFactoryManager {
    private volatile long timer = 0L;
    private PriorityQueue<Callable<Void>> queue;
    private transient InternalWorkingMemory session;
    private TimerJobFactoryManager jobFactoryManager = DefaultTimerJobFactoryManager.instance;
    private AtomicLong idCounter = new AtomicLong();

    public PseudoClockScheduler() {
        this(null);
    }

    public PseudoClockScheduler(InternalWorkingMemory session) {
        this.queue = new PriorityQueue();
        this.session = session;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.timer = in.readLong();
        PriorityQueue tmp = (PriorityQueue)in.readObject();
        if (tmp != null) {
            this.queue = tmp;
        }
        this.session = ((DroolsObjectInputStream)in).getWorkingMemory();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.timer);
        out.writeObject(this.queue.isEmpty() ? null : this.queue);
    }

    @Override
    public void setTimerJobFactoryManager(TimerJobFactoryManager timerJobFactoryManager) {
        this.jobFactoryManager = timerJobFactoryManager;
    }

    @Override
    public TimerJobFactoryManager getTimerJobFactoryManager() {
        return this.jobFactoryManager;
    }

    @Override
    public synchronized long getCurrentTime() {
        return this.timer;
    }

    @Override
    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        Date date = trigger.hasNextFireTime();
        if (date != null) {
            DefaultJobHandle jobHandle = new DefaultJobHandle(this.idCounter.getAndIncrement());
            TimerJobInstance jobInstance = this.jobFactoryManager.createTimerJobInstance(job, ctx, trigger, jobHandle, this);
            jobHandle.setTimerJobInstance(jobInstance);
            this.internalSchedule(jobInstance);
            return jobHandle;
        }
        return null;
    }

    @Override
    public void internalSchedule(TimerJobInstance timerJobInstance) {
        this.jobFactoryManager.addTimerJobInstance(timerJobInstance);
        this.queue.add((Callable)((Object)timerJobInstance));
    }

    @Override
    public boolean removeJob(JobHandle jobHandle) {
        jobHandle.setCancel(true);
        this.jobFactoryManager.removeTimerJobInstance(((DefaultJobHandle)jobHandle).getTimerJobInstance());
        return this.queue.remove((Callable)((Object)((DefaultJobHandle)jobHandle).getTimerJobInstance()));
    }

    @Override
    public synchronized long advanceTime(long amount, TimeUnit unit) {
        this.timer += unit.toMillis(amount);
        this.runCallBacks();
        return this.timer;
    }

    public synchronized void setStartupTime(long i) {
        this.timer = i;
    }

    public synchronized InternalWorkingMemory getSession() {
        return this.session;
    }

    public synchronized void setSession(InternalWorkingMemory session) {
        this.session = session;
    }

    @Override
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCallBacks() {
        long fireTime;
        TimerJobInstance item = (TimerJobInstance)((Object)this.queue.peek());
        while (item != null && item.getTrigger().hasNextFireTime() != null && (fireTime = item.getTrigger().hasNextFireTime().getTime()) <= this.timer) {
            Object var8_5;
            this.queue.remove();
            if (item.getJobHandle().isCancel()) continue;
            long savedTimer = this.timer;
            try {
                try {
                    this.timer = fireTime;
                    ((Callable)((Object)item)).call();
                }
                catch (Exception e) {
                    SystemEventListenerFactory.getSystemEventListener().exception((Throwable)e);
                    var8_5 = null;
                    this.timer = savedTimer;
                }
                var8_5 = null;
                this.timer = savedTimer;
            }
            catch (Throwable throwable) {
                var8_5 = null;
                this.timer = savedTimer;
                throw throwable;
            }
            item = (TimerJobInstance)((Object)this.queue.peek());
        }
    }

    @Override
    public synchronized long getTimeToNextJob() {
        TimerJobInstance item = (TimerJobInstance)((Object)this.queue.peek());
        return item != null ? item.getTrigger().hasNextFireTime().getTime() - this.timer : -1L;
    }

    @Override
    public Collection<TimerJobInstance> getTimerJobInstances() {
        return this.jobFactoryManager.getTimerJobInstances();
    }
}

