% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_MLIE.R
\name{do.mlie}
\alias{do.mlie}
\title{Maximal Local Interclass Embedding}
\usage{
do.mlie(
  X,
  label,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"),
  k1 = max(ceiling(nrow(X)/10), 2),
  k2 = max(ceiling(nrow(X)/10), 2)
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{k1}{the number of same-class neighboring points (homogeneous neighbors).}

\item{k2}{the number of different-class neighboring points (heterogeneous neighbors).}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Maximal Local Interclass Embedding (MLIE) is a linear supervised method that
the local interclass graph and the intrinsic graph are constructed to find a set of
projections that maximize the local interclass scatter and the local
intraclass compactness at the same time. It can be deemed an extended version of MFA.
}
\examples{
\dontrun{
## generate data of 3 types with clear difference
set.seed(100)
diff = 100
dt1  = aux.gensamples(n=20)-diff
dt2  = aux.gensamples(n=20)
dt3  = aux.gensamples(n=20)+diff

## merge the data and create a label correspondingly
X      = rbind(dt1,dt2,dt3)
label  = rep(1:3, each=20)

## try different numbers for neighborhood size
out1 = do.mlie(X, label, k1=5, k2=5)
out2 = do.mlie(X, label, k1=10,k2=10)
out3 = do.mlie(X, label, k1=25,k2=25)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="MLIE::nbd size=5")
plot(out2$Y, main="MLIE::nbd size=10")
plot(out3$Y, main="MLIE::nbd size=25")
par(opar)
}

}
\references{
\insertRef{lai_maximal_2011}{Rdimtools}
}
\seealso{
\code{\link{do.mfa}}
}
\concept{linear_methods}
