% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_NOLPP.R
\name{do.nolpp}
\alias{do.nolpp}
\title{Nonnegative Orthogonal Locality Preserving Projection}
\usage{
do.nolpp(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  preprocess = c("null", "center", "scale", "cscale", "decorrelate", "whiten"),
  t = 1,
  maxiter = 1000,
  reltol = 1e-05
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{t}{kernel bandwidth in \eqn{(0,\infty)}.}

\item{maxiter}{number of maximum iteraions allowed.}

\item{reltol}{stopping criterion for incremental relative error.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Nonnegative Orthogonal Locality Preserving Projection (NOLPP) is a variant of OLPP where
projection vectors - or, basis for learned subspace - contain no negative values.
}
\examples{
\dontrun{
## use iris data
data(iris)
X     = as.matrix(iris[,1:4])+50
label = as.integer(iris$Species)

## use different kernel bandwidths with 20\% connectivity
out1 = do.nolpp(X, type=c("proportion",0.5), t=0.01)
out2 = do.nolpp(X, type=c("proportion",0.5), t=0.1)
out3 = do.nolpp(X, type=c("proportion",0.5), t=1)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=label, main="NOLPP::t=0.01")
plot(out2$Y, col=label, main="NOLPP::t=0.1")
plot(out3$Y, col=label, main="NOLPP::t=1")
par(opar)
}

}
\references{
\insertRef{zafeiriou_nonnegative_2010}{Rdimtools}
}
\seealso{
\code{\link{do.olpp}}
}
\author{
Kisung You
}
\concept{linear_methods}
