% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_DSPP.R
\name{do.dspp}
\alias{do.dspp}
\title{Discriminative Sparsity Preserving Projection}
\usage{
do.dspp(
  X,
  label,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten"),
  lambda = 1,
  rho = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{lambda}{regularization parameter for constructing sparsely weighted network.}

\item{rho}{a parameter for balancing the local and global contribution.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Discriminative Sparsity Preserving Projection (DSPP) is a supervised dimension reduction method
that employs sparse representation model to adaptively build both intrinsic adjacency graph and
penalty graph. It follows an integration of global within-class structure into manifold learning
under exploiting discriminative nature provided from label information.
}
\examples{
\donttest{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.factor(iris$Species)

## try different rho values
out1 <- do.dspp(X, label, ndim=2, rho=0.01)
out2 <- do.dspp(X, label, ndim=2, rho=0.1)
out3 <- do.dspp(X, label, ndim=2, rho=1)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="rho=0.01", col=label, pch=19, cex=0.5)
plot(out2$Y, main="rho=0.1",  col=label, pch=19, cex=0.5)
plot(out3$Y, main="rho=1",    col=label, pch=19, cex=0.5)
par(opar)
}

}
\references{
\insertRef{gao_discriminative_2015}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
