% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_LSPP.R
\name{do.lspp}
\alias{do.lspp}
\title{Local Similarity Preserving Projection}
\usage{
do.lspp(
  X,
  label,
  ndim = 2,
  t = 1,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{t}{kernel bandwidth in \eqn{(0,\infty)}.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Local Similarity Preserving Projection (LSPP) is a variant of LPP in that
it employs a sample-dependent graph generation process as of \code{\link{do.sdlpp}}.
LSPP takes advantage of labeling information to correct local similarity weight
in order to make intra-class weight larger than inter-class weight. It uses
PCA preprocessing as suggested from the original work.
}
\examples{
## generate data of 2 types with clear difference
diff = 15
dt1  = aux.gensamples(n=123)-diff;
dt2  = aux.gensamples(n=123)+diff;

## merge the data and create a label correspondingly
Y      = rbind(dt1,dt2)
label  = c(rep(1,123), rep(2,123))

## compare with PCA
out1 <- do.pca(Y, ndim=2)
out2 <- do.slpp(Y, label, ndim=2)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(out1$Y, main="PCA")
plot(out2$Y, main="LSPP")
par(opar)

}
\references{
\insertRef{huang_local_2015}{Rdimtools}
}
\seealso{
\code{\link{do.sdlpp}}, \code{\link{do.lpp}}
}
\author{
Kisung You
}
