% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadSNOMED.R
\name{loadSNOMED}
\alias{loadSNOMED}
\title{Load SNOMED files from a folder(s) into R data.table objects}
\usage{
loadSNOMED(folders, active_only = TRUE)
}
\arguments{
\item{folders}{Vector of folder paths containing SNOMED CT files}

\item{active_only}{Whether to limit to current (active) SNOMED CT terms}
}
\value{
An environment containing data.table objects: CONCEPT,
  DESCRIPTION, RELATIONSHIP, STATEDRELATIONSHIP
}
\description{
Identifies relevant SNOMED files from a distribution and loads 
them into an R environment. Files from two folders (e.g.
International and UK versions) can be loaded together and appended.
}
\examples{
# Create a TEST environment and load the sample dictionaries
TEST <- sampleSNOMED()

# Export to temporary directory
for (table in c('Concept', 'Description', 'Relationship',
  'StatedRelationship')){
  write.table(get(toupper(table), envir = TEST), paste0(tempdir(),
    '/sct_', table, '_text.txt'), row.names = FALSE, sep = '\t', quote = FALSE)
}

# Try to import using the loadSNOMED function
TEST2 <- loadSNOMED(tempdir(), active_only = FALSE)

# Check that reimported SNOMED dictionary is the same as the original
all.equal(TEST$CONCEPT, TEST2$CONCEPT)
all.equal(TEST$DESCRIPTION, TEST2$DESCRIPTION)
all.equal(TEST$RELATIONSHIP, TEST2$RELATIONSHIP)
all.equal(TEST$STATEDRELATIONSHIP, TEST2$STATEDRELATIONSHIP)
}
