% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{movMeanUE}
\alias{movMeanUE}
\alias{movMeanUEr}
\title{Weighted Simple Moving Mean for Unevenly Spaced Time Series}
\usage{
movMeanUE(vec, pos, n = 1L, ss = 1L, w = NULL, na_rm = FALSE,
  sizeD = FALSE, align = "left")

movMeanUEr(vec, pos, n = 1L, ss = 1L, w = NULL, na_rm = FALSE,
  sizeD = FALSE)
}
\arguments{
\item{vec}{A numeric vector.}

\item{pos}{A numeric vector with all integers. Its length must be the SAME as \eqn{vec}.
N.B. We use integers to represent the (relative) potions of every point.}

\item{n}{An integer: moving window size, with 1 as default}

\item{ss}{An integer: step size, only calculating at points with an equal distance \emph{ss}.
Namely, there are \emph{ss-1} number between each two 'consecutive' points}

\item{w}{An optional weight vector of length \emph{n}. It will be automatically normalized
(sum to 1).}

\item{na_rm}{logical. Should missing values (including NaN) be removed?}

\item{sizeD}{logical. Only applied when \emph{ss > 1}, it decides whether to get a result of 
smaller size. If \eqn{sizeD = T}, \emph{align} does not affect the output.}

\item{align}{A string denotes how to align the moving average, three options: 
"left", "middle", "right"}
}
\value{
This function returns A MATRIX of size: \eqn{L*3}, where L is the length of vector, or 
of size: \eqn{L1*3}, where \eqn{L1 =} \code{\link[base]{ceiling}}\eqn{((nrow - n + 1)/ss)}, 
(when \eqn{sizeD = T}). In the matrix, the first column denotes the position, the second column the 
original vector, and the third column the moving average.
}
\description{
This function returns A matrix: the first column is the position, the second column 
the input vector, and third column simple moving average of the given vector. The weight 
argument is optional.
}
\details{
This function is especially designed for Unevenly Spaced Time Series. It is efficient as it inherits the 
similar routine of \code{movMean}. \cr
The result is kind of tricky. To make it clear, it is written to return a MATRIX. For instance, the 
third column of the output of second example is \eqn{NA, 2.5, 4.0, NA, NA, NA, 3.0, 3.0, 8.0}. 
2.5 is the average of 1 and 4, and 4.0 the average of 4. The third column of the output of 
third example is the every third element starting from \eqn{n}th number. \cr
For how weights, \eqn{w}, work, one can refer to \code{movMean}.
}
\section{Functions}{
\itemize{
\item \code{movMeanUEr}: An function equivalent to \code{movMeanUE(..., align = "right")}
}}

\examples{
movMeanUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), 2)
movMeanUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, na_rm = TRUE)
movMeanUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, 
sizeD = TRUE)
movMeanUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), w = c(0, 1),  n = 2, 
ss = 3, na_rm = TRUE, align = "right")
movMeanUE(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, 
na_rm = TRUE, sizeD = TRUE, align = "right")
movMeanUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9),  n = 2, ss = 3, 
na_rm = TRUE)
movMeanUEr(c(1, 4, 3, NA, 8), pos = c(1, 2, 7, 8, 9), n = 2, ss = 3, na_rm = TRUE, 
sizeD = TRUE)
movMeanUE(rnorm(50), pos = sort(sample(1:100, 50, replace = FALSE)),  n = 5, 
ss = 10, na_rm = TRUE, align = "right")
}
