\name{loglikelihood}
\alias{loglikelihood}

\title{
Multiple observed sequences evaluation given a model
}

\description{
This function computes the log-likelihood of a multiple observed sequences being generated by a hidden Markov model with fixed parameters.
}

\usage{
loglikelihood(hmm, sequences)
}

\arguments{
  \item{hmm}{a list that contains all the necesary variables to define a hidden Markov model.}
  \item{sequences}{a matrix that contains in each row a sequence of observations to be evaluated.}
}

\value{
A value that represents the log likelihood of the multiple observed sequences given the hiddden Markov model.
}

\references{
Cited references are listed on the \link{RcppHMM} manual page.
}

\seealso{
\code{\link{generateObservations}} , \code{\link{verifyModel}} , \code{\link{evaluation}}
}

\examples{
# Set the model parameters
n <- c("First","Second")
m <- c("A","T","C","G")
A <- matrix(c(0.8,0.2,
              0.1,0.9),
            nrow = 2,
            byrow = TRUE)

B <- matrix(c(0.2, 0.2, 0.3, 0.3,
              0.4, 0.4, 0.1, 0.1),
            nrow = 2,
            byrow = TRUE)

Pi <- c(0.5, 0.5)

params <- list( "Model" = "HMM",
                "StateNames" = n,
                "ObservationNames" = m,
                "A" = A,
                "B" = B,
                "Pi" = Pi)

HMM <- verifyModel(params)

# Data simulation
set.seed(100)
length <- 100
seqs <- 100
observationSequences<- c()
for(i in 1:seqs){
  Y <- generateObservations(HMM , length)$Y
  observationSequences <- rbind(observationSequences , Y)
}

dim(observationSequences)
table(observationSequences)

#Sequences evaluation
loglikelihood(HMM, observationSequences)
}

\keyword{methods}
