% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{predict.DPR_Model}
\alias{predict.DPR_Model}
\title{Use a DPR model to predict results from new data}
\usage{
\method{predict}{DPR_Model}(object, newdata, ...)
}
\arguments{
\item{object}{an object of class DPR_Model}

\item{newdata}{Numeric matrix representing the input to the model}

\item{...}{ignored args.}
}
\value{
returns Numeric vector of predictions
}
\description{
Use a DPR model to predict results from new data
}
\examples{
n <- 500
p <- 10775
file_path_x <- system.file("extdata", "data/in/x.rds", package = "RcppDPR")
file_path_y <- system.file("extdata", "data/in/y.rds", package = "RcppDPR")
file_path_w <- system.file("extdata", "data/in/w.rds", package = "RcppDPR")
x = readRDS(file_path_x)
y = readRDS(file_path_y)
w = readRDS(file_path_w)
dpr_model <- fit_model(y, w, x, fitting_method = "VB")
new_x <- matrix(rnorm(n = n * p, mean = 0, sd = 1), nrow = n, ncol = p)
new_y <- predict(dpr_model, new_x)
}
