% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwb.R
\name{cwb_makeall}
\alias{cwb_makeall}
\alias{cwb_huffcode}
\alias{cwb_compress_rdx}
\alias{cwb_encode}
\title{CWB Tools for Creating Corpora}
\usage{
cwb_makeall(corpus, p_attribute, registry = Sys.getenv("CORPUS_REGISTRY"))

cwb_huffcode(corpus, p_attribute, registry = Sys.getenv("CORPUS_REGISTRY"))

cwb_compress_rdx(corpus, p_attribute, registry = Sys.getenv("CORPUS_REGISTRY"))

cwb_encode(
  corpus,
  registry = Sys.getenv("CORPUS_REGISTRY"),
  data_dir,
  vrt_dir,
  p_attributes = c("word", "pos", "lemma"),
  s_attributes
)
}
\arguments{
\item{corpus}{name of a CWB corpus (upper case)}

\item{p_attribute}{name p-attribute}

\item{registry}{path to the registry directory, defaults to the value of the
environment variable CORPUS_REGISTRY}

\item{data_dir}{The data directory where \code{cwb_encode} will put the binary
files of the indexed corpus.}

\item{vrt_dir}{Directory with input corpus files (verticalised format / file
ending *.vrt).}

\item{p_attributes}{Positional attributes (p-attributes) to be declared.}

\item{s_attributes}{A \code{list} of named \code{character} vectors to declare
structural attributes that shall be encoded. The names of the list are the
XML elements present in the corpus. Character vectors making up the list
declare the attributes that include the metadata of regions. To declare a
structural attribute without annotations, provide a zero-length character
vector using \code{character()} - see examples.}
}
\description{
Wrappers for the CWB tools (\code{cwb-makeall}, \code{cwb-huffcode},
\code{cwb-compress-rdx}). Unlike the 'original' command line tools, these
wrappers will always perform a specific indexing/compression step on one
positional attribute, and produce all components.
}
\examples{
# The package includes and 'unfinished' corpus of debates in the UN General 
# Assembly ("UNGA"), i.e. it does not yet include the reverse index, and it is
# not compressed.
#
# The first step in the following example is to copy the raw
# corpus to a temporary place.

registry <- if (!check_pkg_registry_files()) use_tmp_registry() else get_pkg_registry()
home_dir <- system.file(package = "RcppCWB", "extdata", "cwb", "indexed_corpora", "unga")

tmpdir <- normalizePath(tempdir(), winslash = "/")
tmp_regdir <- file.path(tmpdir, "registry_tmp", fsep = "/")
tmp_data_dir <- file.path(tmpdir, "indexed_corpora", fsep = "/")
tmp_unga_dir <- file.path(tmp_data_dir, "unga", fsep = "/")
if (!file.exists(tmp_regdir)) dir.create(tmp_regdir)
if (!file.exists(tmp_data_dir)) dir.create(tmp_data_dir)
if (!file.exists(tmp_unga_dir)){
  dir.create(tmp_unga_dir)
} else {
  file.remove(list.files(tmp_unga_dir, full.names = TRUE))
}
regfile <- readLines(file.path(registry, "unga"))
regfile[grep("^HOME", regfile)] <- sprintf('HOME "\%s"', tmp_unga_dir)
writeLines(text = regfile, con = file.path(tmp_regdir, "unga"))
for (x in list.files(home_dir, full.names = TRUE)){
  file.copy(from = x, to = tmp_unga_dir)
}

# perform cwb_makeall (equivalent to cwb-makeall command line utility)
cwb_makeall(corpus = "UNGA", p_attribute = "word", registry = tmp_regdir)

# see whether it works
ids_sentence_1 <- cl_cpos2id(
  corpus = "UNGA", p_attribute = "word", registry = tmp_regdir,
  cpos = 0:83
  )
tokens_sentence_1 <- cl_id2str(
  corpus = "UNGA", p_attribute = "word",
  registry = tmp_regdir, id = ids_sentence_1
  )
sentence <- gsub("\\\\s+([\\\\.,])", "\\\\1", paste(tokens_sentence_1, collapse = " "))

# perform cwb_huffcode (equivalent to cwb-makeall command line utility)
if (.Platform$OS.type != "windows"){
  cwb_huffcode(corpus = "UNGA", p_attribute = "word", registry = tmp_regdir)
}
if (.Platform$OS.type != "windows"){
  cwb_compress_rdx(corpus = "UNGA", p_attribute = "word", registry = tmp_regdir)
}
if (.Platform$OS.type != "windows"){
data_dir <- file.path(tempdir(), "tmp_data_dir")
dir.create(data_dir)

cwb_encode(
  corpus = "BTMIN",
  registry = Sys.getenv("CORPUS_REGISTRY"),
  vrt_dir = system.file(package = "RcppCWB", "extdata", "vrt"),
  data_dir = data_dir,
  p_attributes = c("word", "pos", "lemma"),
  s_attributes = list(
    plenary_protocol = c(
      "lp", "protocol_no", "date", "year", "birthday", "version",
      "url", "filetype"
    ),
    speaker = c(
      "id", "type", "lp", "protocol_no", "date", "year", "ai_no", "ai_id",
      "ai_type", "who", "name", "parliamentary_group", "party", "role"
     ),
    p = character()
  )
)

unlink(data_dir)
unlink(file.path(Sys.getenv("CORPUS_REGISTRY"), "btmin"))
}
}
