% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check}
\alias{check}
\alias{check_registry}
\alias{check_corpus}
\alias{check_s_attribute}
\alias{check_p_attribute}
\alias{check_strucs}
\alias{check_region_matrix}
\alias{check_cqp_query}
\alias{check_cpos}
\alias{check_id}
\title{Check Input to Rcpp Functions.}
\usage{
check_registry(registry)

check_corpus(corpus, registry)

check_s_attribute(
  s_attribute,
  corpus,
  registry = Sys.getenv("CORPUS_REGISTRY")
)

check_p_attribute(
  p_attribute,
  corpus,
  registry = Sys.getenv("CORPUS_REGISTRY")
)

check_strucs(corpus, s_attribute, strucs, registry)

check_region_matrix(region_matrix)

check_cqp_query(query)

check_cpos(
  corpus,
  p_attribute = "word",
  cpos,
  registry = Sys.getenv("CORPUS_REGISTRY")
)

check_id(corpus, p_attribute, id, registry = Sys.getenv("CORPUS_REGISTRY"))
}
\arguments{
\item{registry}{path to registry directory}

\item{corpus}{name of a CWB corpus}

\item{s_attribute}{a structural attribute}

\item{p_attribute}{a positional attribute}

\item{strucs}{strucs (indices of structural attributes)}

\item{region_matrix}{a region matrix}

\item{query}{a CQP query}

\item{cpos}{vector of corpus positions}

\item{id}{id (encoded p-attribute), integer value}
}
\description{
A set of functions to check whether the input values to the Rcpp
wrappers for the C functions of the Corpus Workbench potentially causing
crashes are valid. These auxiliary functions are called by the cl_ and cqp_
functions.
}
