% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl.R
\name{cl_lexicon_size}
\alias{cl_lexicon_size}
\title{Get Lexicon Size.}
\usage{
cl_lexicon_size(corpus, p_attribute,
  registry = Sys.getenv("CORPUS_REGISTRY"))
}
\arguments{
\item{corpus}{name of a CWB corpus (upper case)}

\item{p_attribute}{name of positional attribute}

\item{registry}{path to the registry directory, defaults to the value of the
environment variable CORPUS_REGISTRY}
}
\description{
Get the total number of unique tokens/ids of a positional attribute. Note
that token ids are zero-based, i.e. when iterating through tokens, start at
0, the maximum will be \code{cl_lexicon_size()} minus 1.
}
\examples{
registry <- if (!check_pkg_registry_files()) use_tmp_registry() else get_pkg_registry()
Sys.setenv(CORPUS_REGISTRY = registry)
lexicon_size <- cl_lexicon_size("REUTERS", p_attribute = "word")
token_ids <- seq.int(from = 0, to = lexicon_size - 1)
cl_id2str("REUTERS", p_attribute = "word", id = token_ids)
}
