% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdb_collapse.R
\name{cdb_collapse}
\alias{cdb_collapse}
\title{Collapse a COM(P)ADRE database by averaging matrices over levels of one or
more grouping variables}
\usage{
cdb_collapse(cdb, columns)
}
\arguments{
\item{cdb}{A CompadreDB object}

\item{columns}{Vector of grouping variables to collapse over (corresponding
to columns within \code{cdb})}
}
\value{
A CompadreDB object
}
\description{
Collapses a CompadreDB object by averaging matrices over levels of one or
more grouping variables (e.g. SpeciesAuthor, MatrixPopulation).

For a given study and species, a COM(P)ADRE database may contain multiple
matrices, reflecting different combinations of population, year, and/or
treatment. Collapsing allows a user to obtain a single 'grand mean matrix'
for each group of interest (e.g. MatrixPopulation), and therefore limit
pseudoreplication.

All members of a group \emph{must} have the same matrix dimension (consider
adding MatrixDimension as a grouping variable). All members of a group
\emph{should} have the same ProjectionInterval and matrix stage class
definitions (see \code{\link{cdb_id_stages}}). Note that Seasonal matrices
should not be collapsed using this method (they should be matrix-multiplied
rather than averaged).
}
\details{
Will give a warning if members of any group do not all share the same
ProjectionInterval or stage class definitions, or if \code{cdb} contains any
rows with a MatrixComposite value of "Seasonal".

Prior to collapsing, columns of class 'factor' will be coerced to
'character', and any list-column apart from \code{mat} will be removed.

Within a group, rows of a given column are collapsed as follows:

\itemize{
  \item \code{mat}: matrices are averaged using \link{mpm_mean}, and stage
    class definitions are taken from the first group member
  \item \code{MatrixComposite}: return original value if N = 1, else return
    "Collapsed"
  \item \code{Lat}: re-calculated by averaging Lat column (if available)
  \item \code{Lon}: re-calculated by averaging Lon column (if available)
  \item \code{SurvivalIssue}: re-calculated from the collapsed \code{mat}
    (\code{max(colSums(matU))})
  \item \code{others}: if all elements equal return that unique value, else
    paste together all unique values separated by "; "
}
}
\examples{
# filter out Seasonal matrices
CompSub <- subset(Compadre, MatrixComposite != "Seasonal")

# add column identifying unique stage class definitions
CompSub$id_stage <- cdb_id_stages(CompSub, "MatrixClassOrganized")

# collapse
CompCollapse <- cdb_collapse(CompSub, columns = c("id_stage"))

}
\seealso{
\link{cdb_id_stages}

Other data checking: 
\code{\link{cdb_check_species}()},
\code{\link{cdb_compare}()},
\code{\link{cdb_flag}()},
\code{\link{mpm_methods}}
}
\author{
Patrick M. Barks <patrick.barks@gmail.com>

Owen R. Jones <jones@biology.sdu.dk>
}
\concept{data checking}
