% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Rchoice.methods.R
\name{cov.Rchoice}
\alias{cor.Rchoice}
\alias{cov.Rchoice}
\alias{se.cov.Rchoice}
\title{Functions for correlated random parameters}
\usage{
cov.Rchoice(x)

cor.Rchoice(x)

se.cov.Rchoice(x, sd = FALSE, digits = max(3, getOption("digits") - 2))
}
\arguments{
\item{x}{a object of class \code{Rchoice} where \code{ranp} is not \code{NULL},}

\item{sd}{if \code{TRUE}, then the standard deviations of the random parameters along with their standard errors are computed,}

\item{digits}{the number of digits,}

\item{...}{further arguments}
}
\value{
\code{cov.Rchoice} returns a matrix with the variance of the random parameters if model is fitted with random coefficients. If the model is fitted with \code{correlation = TRUE}, then the variance-covariance matrix is returned.


If \code{correlation = TRUE} in the fitted model, then  \code{se.cov.Rchoice} returns a coefficient matrix for the elements of the variance-covariance matrix or the standard deviations if \code{sd = TRUE}.
}
\description{
These are a set of functions that help to extract the variance-covariance matrix, the correlation matrix, and the standard error of the random parameters for models of class \code{Rchoice}.
}
\details{
The variance-covariance matrix is computed using \eqn{LL'=\Sigma}, where \eqn{L} is the Cholesky matrix.


\code{se.cov.Rchoice} function is a wrapper for \code{\link[msm]{deltamethod}} function of \pkg{msm} package.
}
\examples{
\dontrun{
## Estimate a poisson model with correlated random parameters
data("Articles")
poissonc.ran <- Rchoice(art ~ fem + mar + kid5 + phd + ment,
                       data = Articles,
                       ranp = c(kid5 = "n", phd = "n", ment = "n"),
                       family = poisson,
                       correlation =  TRUE)

## Functions for models with correlated random parameters
cov.Rchoice(poissonc.ran)
cor.Rchoice(poissonc.ran)
se.cov.Rchoice(poissonc.ran)
se.cov.Rchoice(poissonc.ran, sd = TRUE)
}
}
\references{
\itemize{
\item Greene, W. H. (2012). Econometric Analysis, Seventh Edition. Pearson Hall.
\item Train, K. (2009). Discrete Choice Methods with Simulation. Cambridge university press.
}
}
\seealso{
\code{\link[Rchoice]{Rchoice}} for the estimation of discrete choice models with individual heterogeneity.
}

