

\name{plot_geopos}
\alias{plot_geopos}
\alias{get_geopos}

\title{
reads and plots geolocation estimates derived from archival tagging data
}
\description{
In case that geolocations are provided by csv-files or data frames, line and scatter plots are implemented.
In case of ncdf-files, generated by the \href{http://my.wildlifecomputers.com/}{Wildlife Computers-data portal}, are selected, a \link{SpatialPolygonsDataFrame} will be created and a surface probability maps are illustrated. The latter procedure is based on the R-code given in the \href{https://static.wildlifecomputers.com/manuals/Location-Processing-User-Guide.pdf}{location processing user guide} by \href{http://wildlifecomputers.com/}{Wildlife Computers}.
}
\usage{
plot_geopos(x, xlim, ylim, date_format, lang_format="en", tz="UTC", cb.date_format,
            cbpos, cbline = 0, cb.xlab = "", prob_lim=.75, pal="jet", alpha=70, type="p", 
            pch=19, cex=1, lwd=1, add=FALSE, Return=FALSE, main = "", ...)
            
get_geopos(x, xlim, ylim, date_format, lang_format="en", tz="UTC", 
           add=FALSE, prob_lim=.75)
}


 

\arguments{
\item{x}{

\link{data.frame} containing horziontal position records (allowed column names are 'Most.Likely.Longitude', 'Longitude' or 'Lon' and 'Most.Likely.Latitude', 'Latitude' or 'Lat', respectively. path and file name of \code{.csv} or \code{.nc}-file, or loaded nc-file via \code{get_geopos}.
}


%\item{v_area}{
%Character string used as a short key by the \link{oceanmap}-package to identify region (limits) to be plotted. See   \link{region_definitions} for existing for region definitions and use add.region to define new ones.
%}

\item{xlim, ylim}{
Numeric vector, defining the limts of the x and y-axes.
}

\item{date_format, lang_format, tz}{
character strings indicating the date format, language format and the corresponding time zone, defined by the vectors Date and Time (by default: date_format="\%d-\%b-\%Y \%H:\%M:\%S", lang_format="en", tz='UTC')
If formatting fails, please check as well the input language format, defined by \code{lang_format} (and use abbrviations such as "en" for English,"es" for Spanish, "fr" for French, etc.) as well.
}

\item{cb.date_format}{
character strings indicating the date format of the color bar ticks (by default "\%Y-\%m-\%d").
}

\item{cbpos}{
 letter ("b", "r") indicating the position of the colorbar (bottom, right). 
}

\item{cbline}{
 numeric value, indicating the line of the colorbar placement relative to the plot.
}

\item{cb.xlab}{
character string indicating the x-axis label of the colorbar.
}


\item{prob_lim}{
in case that a netcdf-file (.nc) is selected, the value defines the limit of the probability surfaces in \% (By default 75\%). Otherwise ignored.
}

\item{pal}{
  color map to be plotted in case of polygon (.nc-files) or scatter plots (default is the 'jet'-colormap). See \link{cmap} for pre-installed color maps. Note that tracking data with constant time steps is being assumed in the color assignment. To verify this, a \link{data.frame} containing the colors at each time steps will be returned for polygon and scatter plots.
}


\item{alpha}{transparency of polygons and dots to be plotted in percent (By default 70\%).
}

\item{type}{
character string giving the type of plot desired. The following values are possible, for details (By default "p" for points, but "l" for lines is also implemented).
}

\item{pch, cex}{
dot-type and size to be plotted if 'points' have been selected (By default '19' for solid dots).
}

\item{lwd}{
line width (applies only in case of line plots).
}

\item{add}{
whether the a the plot should be added to an existent figure (default is \code{FALSE})
}

\item{\dots}{
additional arguments to be passed to \link{plotmap}.
}

\item{Return}{
whether edited time series data set should be returned (by default \code{FALSE}).
}

\item{main}{
an overall title for the plot
}

}



\seealso{\link{plotmap}, \link{plot_DepthTS}, \link{hist_tat}, \link{hist_tad}} 


\author{
Robert K. Bauer
}

\examples{
# ## example 1a) line plot from csv-file:
csv_file <- system.file("example_files/15P1019-104659-1-GPE3.csv",package="RchivalTag")
pos <- get_geopos(csv_file) ## show tracks as line plot
# plot_geopos(pos, type='l', add=FALSE) ## show tracks as line plot
# plot_geopos(csv_file, type='l', add=FALSE) ## same result
# 
# ## example 1b) scatter plot from csv-file on existing landmask:
# require('oceanmap')
# plotmap('lion') ## use keyword to derive area limits
# plot_geopos(csv_file, add=TRUE,alpha = 100) ## show tracks as scatter plot
# 
# ## example 1c) scatter plot from csv-file on existing landmask:
# require('oceanmap')
# pos <- get_geopos(csv_file)
# plotmap('lion') ## use keyword to derive area limits
# plot_geopos(pos, add=TRUE) ## show tracks as scatter plot
# plot_geopos(pos, add=FALSE, cb.date_format="%d %b") ## show tracks as scatter plot
# 
# 
# ## example 2) probability surfaces of horizontal tracks from nc-file:
# ## this can take some time as it inlcudes time consuming data processing
# nc_file <- system.file("example_files/15P1019-104659-1-GPE3.nc",package="RchivalTag") 
# plot_geopos(nc_file)
# 
# 
# ## alternative: load file first, then plot:
# pols_df <- get_geopos(nc_file) ## loads tracks as SpatialPolygonsDataFrame
# plotmap('lion') ## use keyword to derive area limits
# plot_geopos(pols_df,add = TRUE)
# lines(pos$Lon, pos$Lat)
# points(pos$Lon, pos$Lat,pch=19,cex=.7)




}

