% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_write_Raven_table.R
\name{rvn_write_Raven_table}
\alias{rvn_write_Raven_table}
\title{Writes a nicely formatted tables of Raven attributes/parameters}
\usage{
rvn_write_Raven_table(
  attributes,
  units,
  df,
  filename,
  id_col = TRUE,
  justify = "right",
  sep = ", ",
  ...
)
}
\arguments{
\item{attributes}{array of strings containing attribute/parameter names}

\item{units}{array of strings with the corresponding units}

\item{df}{Dataframe of values corresponding to attributes/parameters}

\item{filename}{Name of the file, with extension, to append the table to}

\item{id_col}{\code{TRUE/FALSE} of whether an numeric id column is the first column in the table
and, in common Raven fashion, does not have a corresponding attribute (default \code{TRUE})}

\item{justify}{alignment of character columns (default 'right'). See \code{\link{format}}}

\item{sep}{character(s) used to seperate columns (default ', ')}

\item{...}{Extra arguments for \code{\link{write.fwf}}}
}
\value{
\item{TRUE}{returns \code{TRUE} if executed successfully}
}
\description{
Writes a nicely formatted tables of Raven attributes/parameters
}
\examples{
soil_classes <- data.frame('Attributes' = c('DEFAULT','ALTERNATIVE'),
                           'SAND'      = c(0.4316, 0.3000),
                           'CLAY'      = c(0.1684, 0.4000),
                           'SILT'      = c(0.4000, 0.3000),
                           'ORGANIC'   = c(0.0000, 0.0000))
attributes <- c('\%SAND','\%CLAY','\%SILT','\%ORGANIC')
units <-  rep('none',4)

tf <- file.path(tempdir(), "Hogwarts.rvp")
rvn_write_Raven_table(tf, attributes = attributes, units = units, df = soil_classes)

# view file
readLines(tf)

}
\author{
Leland Scantlebury, \email{leland@scantle.com}
}
