% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_write_Raven_newfile.R
\name{rvn_write_Raven_newfile}
\alias{rvn_write_Raven_newfile}
\title{Opens/Creates a new file, writes common file header.}
\usage{
rvn_write_Raven_newfile(
  filename,
  description,
  filetype,
  author = NULL,
  creationDate = TRUE,
  linelen = 74,
  textlen = 40
)
}
\arguments{
\item{filename}{Name of the file, with extension}

\item{description}{File Description (e.g., Basin or project information, R script name)}

\item{filetype}{File extension, Encoding, Raven version (e.g. "rvp ASCII Raven 2.9.1")}

\item{author}{Name of file author (optional)}

\item{creationDate}{Bool of whether creation date should be added to header. (default TRUE)}

\item{linelen}{length (width) of header, in text characters (default: 74)}

\item{textlen}{Length of textlines (default: 40, used to right-align text)}
}
\value{
TRUE returns TRUE if executed successfully
}
\description{
Opens/Creates a new file, writes common file header.
}
\examples{
tf <- file.path(tempdir(), "HogwartsBasin.rvp")
rvn_write_Raven_newfile(filename = tf,
                description = "Hogwarts River Basin RVP File Generated by HP_FileGen.R",
                filetype = "rvp ASCII Raven 2.9.1",
                author = 'Harry Potter')

# view file
readLines(tf)

}
\author{
Leland Scantlebury, \email{leland@scantle.com}
}
