% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvt_obsfile_irregular.R
\name{rvn_rvt_obsfile_irregular}
\alias{rvn_rvt_obsfile_irregular}
\title{Create Raven irregular observation data (rvt) file}
\usage{
rvn_rvt_obsfile_irregular(
  filename,
  ts,
  SBID,
  typestr = "HYDROGRAPH",
  units = "m3/s"
)
}
\arguments{
\item{filename}{observation data file to be created, with .rvt extension}

\item{ts}{xts time series with single data column (with discontinuous observations)}

\item{SBID}{Subbasin ID for hydrographs and reservoir stages or HRU ID for observations of state variables (e.g., snow depth)}

\item{typestr}{Raven-recognized data type string: 'HYDROGRAPH', 'RESERVOIR_STAGE', 'RESERVOIR_INFLOW', 'RESERVOIR_NET_INFLOW',
or a state variable name (e.g., SOIL[0] or SNOW)}

\item{units}{units of the data (should be consistent with Raven units; neither Raven nor this routine checks or corrects}
}
\value{
{TRUE}{ returns TRUE if function runs properly}
}
\description{
Creates an observation data file named filename from a discontinuous xts time series ts
}
\examples{

# locate hydrograph sample csv data from RavenR package
ff <- system.file("extdata","run1_Hydrographs.csv", package="RavenR")

# read in Raven Hydrographs file, store into mydata
mydata <- rvn_hyd_read(ff, tzone="EST")

# generate rvt file using just observations from Subbasin ID 36
flows <- rvn_ts_infill(mydata$hyd$Sub36_obs)

# generate irregular series by removing some points
ind <- sort(sample(seq(2,length(flows)-1), size=300, replace=FALSE))

tf <- file.path(tempdir(), "run1_Hydrographs.rvt")
rvn_rvt_obsfile_irregular(tf, flows[-ind], 36, typestr = "HYDROGRAPH")
readLines(tf) \%>\% head()


}
\seealso{
\code{\link{rvn_rvt_obsfile}} for writing continous observation data
}
