% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_forcings_read.R
\name{rvn_forcings_read}
\alias{rvn_forcings_read}
\title{Read in Raven ForcingFunctions file}
\usage{
rvn_forcings_read(ff = NA, tzone = NULL)
}
\arguments{
\item{ff}{full file path to the ForcingFunctions.csv file}

\item{tzone}{string indicating the timezone of the data in ff}
}
\value{
\item{forcings}{data frame from the file with standardized names}
 \item{units}{vector corresponding to units of each column}
}
\description{
rvn_forcings_read is used to read in the ForcingFunctions.csv file produced by
the modelling Framework Raven.
}
\details{
This function expects a full file path to the ForcingFunctions.csv file,
then reads in the file using read.csv. The main advantage of this functon is
renaming the columns to nicer names and extracting the units into something
much easier to read.

ff is the full file path of the ForcingFunctions.csv file. If the file is
located in the current working directory, then simply the name of the file
is sufficient.
}
\examples{

# read in sample forcings data
ff <- system.file("extdata","run1_ForcingFunctions.csv", package="RavenR")
myforcings <- rvn_forcings_read(ff)

# check data (first 5 columns for brevity)
head(myforcings$forcings[,1:5])
summary(myforcings$forcings[,1:5])

}
\seealso{
\code{\link{rvn_hyd_read}} for reading in the Hydrographs.csv file
}
