% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_apriori_rules.R
\name{run_apriori_rules}
\alias{run_apriori_rules}
\title{Generate rules using the apriori algorithm}
\usage{
run_apriori_rules(
  apriori_input_df,
  combo_length,
  support_threshold,
  input_colname_list,
  confidence_threshold = confidence_threshold,
  output_colname_list = output_colname_list
)
}
\arguments{
\item{apriori_input_df}{An input factorized Boolean dataframe with multiple input and outcome variables}

\item{combo_length}{The length of the combinations specified by the user}

\item{support_threshold}{Minimum support value calculated based on the minimum absolute observed frequency threshold specified by the user}

\item{input_colname_list}{A list of column names that identify the input variables}

\item{confidence_threshold}{Minimum confidence threshold specified by the user}

\item{output_colname_list}{Optional | A list of column names that identify the outcome variables}
}
\value{
A list of rules that meet all the constraints supplied to the apriori algorithm
}
\description{
This function takes in a factorized Boolean matrix and generate rules that meet
all the user provided criteria while restricting the RHS of the rule based on
the list of variables allowed in RHS provided by the calling function.
}
\details{
This is a function leveraged by few of the four main methods available to the users.
}
\author{
Vijay Kumar Pounraja
}
