% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vital_rates.R
\name{vital_rates}
\alias{vital_rates}
\title{Derive mean vital rates from a matrix population model}
\usage{
vital_rates(
  matU,
  matF,
  matC = NULL,
  weights = NULL,
  splitStages = "all",
  matrixStages = NULL
)
}
\arguments{
\item{matU}{The survival component of a matrix population model (i.e., a
square projection matrix reflecting survival-related transitions; e.g.
progression, stasis, and retrogression).}

\item{matF}{The sexual component of a matrix population model (i.e., a square
projection matrix reflecting transitions due to sexual reproduction)}

\item{matC}{The clonal component of a matrix population model (i.e., a square
projection matrix reflecting transitions due to clonal reproduction).
Defaults to \code{NULL}, indicating no clonal reproduction (i.e.
\code{matC} is a matrix of zeros).}

\item{weights}{Vector of stage-specific weights to apply while averaging
vital rates. Default is \code{NULL} reflecting equal weighting for all
stages. May also be \code{"SSD"} to weight vital rates by the stable
distribution of \code{matA}.}

\item{splitStages}{What groups should vital rates be averaged over. Either:

\code{"all"}: all stages grouped.

\code{"ontogeny"}: group juvenile stages (all stages prior to the first stage
with sexual reproduction) and adult stages.

\code{"matrixStages"}: group according to a standardized set of stage classes
(propagule, active, and dormant). If \code{splitStages = "matrixStages"},
must also specify separate argument \code{matrixStages}.}

\item{matrixStages}{Vector of stage-specific standardized matrix classes
("prop" for propagule, "active", and/or "dorm" for dormant). Only used if
\code{splitStages = "matrixClass"}.}
}
\value{
A list of averaged vital rates.
}
\description{
Derive mean vital rates corresponding to separate demographic processes from
a matrix population model. Specifically, this function decomposes vital rates
of survival, progression, retrogression, sexual reproduction and clonal
reproduction, with various options for weighting and grouping stages of the
life cycle.
}
\examples{
matU <- rbind(
  c(0.1, 0, 0, 0),
  c(0.5, 0.2, 0.1, 0),
  c(0, 0.3, 0.3, 0.1),
  c(0, 0, 0.5, 0.6)
)

matF <- rbind(
  c(0, 0, 1.1, 1.6),
  c(0, 0, 0.8, 0.4),
  c(0, 0, 0, 0),
  c(0, 0, 0, 0)
)

matC <- rbind(
  c(0, 0, 0.4, 0.5),
  c(0, 0, 0.3, 0.1),
  c(0, 0, 0, 0),
  c(0, 0, 0, 0)
)

# Vital rate outputs without weights
vital_rates(matU, matF, matC, splitStages = "all")
vital_rates(matU, matF, matC, splitStages = "ontogeny")

# Group vital rates according to specified matrixStages
ms <- c("prop", "active", "active", "active")
vital_rates(matU, matF, matC,
  splitStages = "matrixStages",
  matrixStages = ms
)

# Vital rate outputs weighted by the stable stage distribution of 'matA'
vital_rates(matU, matF, matC, splitStages = "all", weights = "SSD")

}
\references{
Caswell, H. 2001. Matrix Population Models: Construction,
  Analysis, and Interpretation. Sinauer Associates; 2nd edition. ISBN:
  978-0878930968
}
\seealso{
Other vital rates: 
\code{\link{vr_mat}},
\code{\link{vr_vec}},
\code{\link{vr}}
}
\author{
Roberto Salguero-Gomez <rob.salguero@zoo.ox.ac.uk>
}
\concept{vital rates}
