/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.clusterers.UpdateableClusterer;
import weka.core.CheckScheme;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SerializationHelper;
import weka.core.TestInstances;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class CheckClusterer
extends CheckScheme {
    protected Clusterer m_Clusterer = new SimpleKMeans();

    public CheckClusterer() {
        this.setNumInstances(40);
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tFull name of the clusterer analyzed.\n\teg: weka.clusterers.SimpleKMeans\n\t(default weka.clusterers.SimpleKMeans)", "W", 1, "-W"));
        if (this.m_Clusterer != null && this.m_Clusterer instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to clusterer " + this.m_Clusterer.getClass().getName() + ":"));
            Enumeration enumeration2 = ((OptionHandler)((Object)this.m_Clusterer)).listOptions();
            while (enumeration2.hasMoreElements()) {
                vector.addElement(enumeration2.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('N', stringArray);
        super.setOptions(stringArray);
        if (string.length() != 0) {
            this.setNumInstances(Integer.parseInt(string));
        } else {
            this.setNumInstances(40);
        }
        string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            string = SimpleKMeans.class.getName();
        }
        this.setClusterer((Clusterer)this.forName("weka.clusterers", Clusterer.class, string, Utils.partitionOptions(stringArray)));
    }

    public String[] getOptions() {
        int n;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        if (this.getClusterer() != null) {
            vector.add("-W");
            vector.add(this.getClusterer().getClass().getName());
        }
        if ((stringArray = this.m_Clusterer != null && this.m_Clusterer instanceof OptionHandler ? ((OptionHandler)((Object)this.m_Clusterer)).getOptions() : new String[]{}).length > 0) {
            vector.add("--");
            for (n = 0; n < stringArray.length; ++n) {
                vector.add(stringArray[n]);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void doTests() {
        if (this.getClusterer() == null) {
            this.println("\n=== No clusterer set ===");
            return;
        }
        this.println("\n=== Check on Clusterer: " + this.getClusterer().getClass().getName() + " ===\n");
        this.println("--> Checking for interfaces");
        this.canTakeOptions();
        boolean bl = this.updateableClusterer()[0];
        boolean bl2 = this.weightedInstancesHandler()[0];
        boolean bl3 = this.multiInstanceHandler()[0];
        this.println("--> Clusterer tests");
        this.declaresSerialVersionUID();
        this.runTests(bl2, bl3, bl);
    }

    public void setClusterer(Clusterer clusterer) {
        this.m_Clusterer = clusterer;
    }

    public Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    protected void runTests(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.canPredict(true, false, false, false, false, bl2)[0];
        boolean bl5 = this.canPredict(false, true, false, false, false, bl2)[0];
        boolean bl6 = this.canPredict(false, false, true, false, false, bl2)[0];
        boolean bl7 = this.canPredict(false, false, false, true, false, bl2)[0];
        boolean bl8 = !bl2 ? this.canPredict(false, false, false, false, true, bl2)[0] : false;
        if (bl4 || bl5 || bl6 || bl7 || bl8) {
            if (bl) {
                this.instanceWeights(bl4, bl5, bl6, bl7, bl8, bl2);
            }
            this.canHandleZeroTraining(bl4, bl5, bl6, bl7, bl8, bl2);
            boolean bl9 = this.canHandleMissing(bl4, bl5, bl6, bl7, bl8, bl2, true, 20)[0];
            if (bl9) {
                this.canHandleMissing(bl4, bl5, bl6, bl7, bl8, bl2, true, 100);
            }
            this.correctBuildInitialisation(bl4, bl5, bl6, bl7, bl8, bl2);
            this.datasetIntegrity(bl4, bl5, bl6, bl7, bl8, bl2, bl9);
            if (bl3) {
                this.updatingEquality(bl4, bl5, bl6, bl7, bl8, bl2);
            }
        }
    }

    protected boolean[] canTakeOptions() {
        boolean[] blArray = new boolean[2];
        this.print("options...");
        if (this.m_Clusterer instanceof OptionHandler) {
            this.println("yes");
            if (this.m_Debug) {
                this.println("\n=== Full report ===");
                Enumeration enumeration = ((OptionHandler)((Object)this.m_Clusterer)).listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    this.print(option.synopsis() + "\n" + option.description() + "\n");
                }
                this.println("\n");
            }
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] updateableClusterer() {
        boolean[] blArray = new boolean[2];
        this.print("updateable clusterer...");
        if (this.m_Clusterer instanceof UpdateableClusterer) {
            this.println("yes");
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] weightedInstancesHandler() {
        boolean[] blArray = new boolean[2];
        this.print("weighted instances clusterer...");
        if (this.m_Clusterer instanceof WeightedInstancesHandler) {
            this.println("yes");
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] multiInstanceHandler() {
        boolean[] blArray = new boolean[2];
        this.print("multi-instance clusterer...");
        if (this.m_Clusterer instanceof MultiInstanceCapabilitiesHandler) {
            this.println("yes");
            blArray[0] = true;
        } else {
            this.println("no");
            blArray[0] = false;
        }
        return blArray;
    }

    protected boolean[] declaresSerialVersionUID() {
        boolean[] blArray = new boolean[2];
        this.print("serialVersionUID...");
        boolean bl = blArray[0] = !SerializationHelper.needsUID(this.m_Clusterer.getClass());
        if (blArray[0]) {
            this.println("yes");
        } else {
            this.println("no");
        }
        return blArray;
    }

    protected boolean[] canPredict(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.print("basic predict");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("unary");
        fastVector.addElement("binary");
        fastVector.addElement("nominal");
        fastVector.addElement("numeric");
        fastVector.addElement("string");
        fastVector.addElement("date");
        fastVector.addElement("relational");
        fastVector.addElement("multi-instance");
        fastVector.addElement("not in classpath");
        int n = this.getNumInstances();
        int n2 = 0;
        boolean bl7 = false;
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n2, bl7, n, fastVector);
    }

    protected boolean[] canHandleZeroTraining(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.print("handle zero training instances");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("train");
        fastVector.addElement("value");
        int n = 0;
        int n2 = 0;
        boolean bl7 = false;
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n2, bl7, n, fastVector);
    }

    protected boolean[] correctBuildInitialisation(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        boolean[] blArray;
        block16: {
            blArray = new boolean[2];
            this.print("correct initialisation during buildClusterer");
            this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6);
            this.print("...");
            int n = this.getNumInstances();
            int n2 = 0;
            boolean bl7 = false;
            Instances instances = null;
            Instances instances2 = null;
            Clusterer clusterer = null;
            ClusterEvaluation clusterEvaluation = null;
            ClusterEvaluation clusterEvaluation2 = null;
            ClusterEvaluation clusterEvaluation3 = null;
            boolean bl8 = false;
            int n3 = 0;
            try {
                instances = this.makeTestDataset(42, n, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, bl6);
                instances2 = this.makeTestDataset(84, n, bl ? this.getNumNominal() + 1 : 0, bl2 ? this.getNumNumeric() + 1 : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, bl6);
                if (bl && !bl6) {
                    instances.deleteAttributeAt(0);
                    instances2.deleteAttributeAt(0);
                }
                if (n2 > 0) {
                    this.addMissing(instances, n2, bl7);
                    this.addMissing(instances2, n2, bl7);
                }
                clusterer = Clusterer.makeCopies(this.getClusterer(), 1)[0];
                clusterEvaluation = new ClusterEvaluation();
                clusterEvaluation2 = new ClusterEvaluation();
                clusterEvaluation3 = new ClusterEvaluation();
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                n3 = 0;
                clusterer.buildClusterer(instances);
                bl8 = true;
                clusterEvaluation.setClusterer(clusterer);
                clusterEvaluation.evaluateClusterer(instances);
                n3 = 1;
                bl8 = false;
                clusterer.buildClusterer(instances2);
                bl8 = true;
                clusterEvaluation3.setClusterer(clusterer);
                clusterEvaluation3.evaluateClusterer(instances2);
                n3 = 2;
                bl8 = false;
                clusterer.buildClusterer(instances);
                bl8 = true;
                clusterEvaluation2.setClusterer(clusterer);
                clusterEvaluation2.evaluateClusterer(instances);
                n3 = 3;
                if (!clusterEvaluation.equals(clusterEvaluation2)) {
                    if (this.m_Debug) {
                        this.println("\n=== Full report ===\n");
                        this.println("First buildClusterer()");
                        this.println(clusterEvaluation.clusterResultsToString() + "\n\n");
                        this.println("Second buildClusterer()");
                        this.println(clusterEvaluation2.clusterResultsToString() + "\n\n");
                    }
                    throw new Exception("Results differ between buildClusterer calls");
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block16;
                this.println("\n=== Full Report ===");
                this.print("Problem during");
                if (bl8) {
                    this.print(" testing");
                } else {
                    this.print(" training");
                }
                switch (n3) {
                    case 0: {
                        this.print(" of dataset 1");
                        break;
                    }
                    case 1: {
                        this.print(" of dataset 2");
                        break;
                    }
                    case 2: {
                        this.print(" of dataset 1 (2nd build)");
                        break;
                    }
                    case 3: {
                        this.print(", comparing results from builds of dataset 1");
                    }
                }
                this.println(": " + exception.getMessage() + "\n");
                this.println("here are the datasets:\n");
                this.println("=== Train1 Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Train2 Dataset ===\n" + instances2.toString() + "\n");
            }
        }
        return blArray;
    }

    protected boolean[] canHandleMissing(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n) {
        if (n == 100) {
            this.print("100% ");
        }
        this.print("missing");
        if (bl7) {
            this.print(" predictor");
        }
        this.print(" values");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6);
        this.print("...");
        FastVector fastVector = new FastVector();
        fastVector.addElement("missing");
        fastVector.addElement("value");
        fastVector.addElement("train");
        int n2 = this.getNumInstances();
        return this.runBasicTest(bl, bl2, bl3, bl4, bl5, bl6, n, bl7, n2, fastVector);
    }

    protected boolean[] instanceWeights(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        boolean[] blArray;
        block14: {
            this.print("clusterer uses instance weights");
            this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6);
            this.print("...");
            int n = 2 * this.getNumInstances();
            int n2 = 0;
            boolean bl7 = false;
            blArray = new boolean[2];
            Instances instances = null;
            Clusterer[] clustererArray = null;
            ClusterEvaluation clusterEvaluation = null;
            ClusterEvaluation clusterEvaluation2 = null;
            boolean bl8 = false;
            boolean bl9 = false;
            try {
                instances = this.makeTestDataset(42, n, bl ? this.getNumNominal() + 1 : 0, bl2 ? this.getNumNumeric() + 1 : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, bl6);
                if (bl && !bl6) {
                    instances.deleteAttributeAt(0);
                }
                if (n2 > 0) {
                    this.addMissing(instances, n2, bl7);
                }
                clustererArray = Clusterer.makeCopies(this.getClusterer(), 2);
                clusterEvaluation = new ClusterEvaluation();
                clusterEvaluation2 = new ClusterEvaluation();
                clustererArray[0].buildClusterer(instances);
                clusterEvaluation.setClusterer(clustererArray[0]);
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                for (int i = 0; i < instances.numInstances(); ++i) {
                    instances.instance(i).setWeight(0.0);
                }
                Random random = new Random(1L);
                for (int i = 0; i < instances.numInstances() / 2; ++i) {
                    int n3 = Math.abs(random.nextInt()) % instances.numInstances();
                    int n4 = Math.abs(random.nextInt()) % 10 + 1;
                    instances.instance(n3).setWeight(n4);
                }
                clustererArray[1].buildClusterer(instances);
                bl8 = true;
                clusterEvaluation2.setClusterer(clustererArray[1]);
                if (clusterEvaluation.equals(clusterEvaluation2)) {
                    bl9 = true;
                    throw new Exception("evalFail");
                }
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block14;
                this.println("\n=== Full Report ===");
                if (bl9) {
                    this.println("Results don't differ between non-weighted and weighted instance models.");
                    this.println("Here are the results:\n");
                    this.println("\nboth methods\n");
                    this.println(clusterEvaluation.clusterResultsToString());
                } else {
                    this.print("Problem during");
                    if (bl8) {
                        this.print(" testing");
                    } else {
                        this.print(" training");
                    }
                    this.println(": " + exception.getMessage() + "\n");
                }
                this.println("Here is the dataset:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                this.println("=== Train Weights ===\n");
                for (int i = 0; i < instances.numInstances(); ++i) {
                    this.println(" " + (i + 1) + "    " + instances.instance(i).weight());
                }
            }
        }
        return blArray;
    }

    protected boolean[] datasetIntegrity(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        boolean[] blArray;
        block6: {
            this.print("clusterer doesn't alter original datasets");
            this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6);
            this.print("...");
            int n = this.getNumInstances();
            int n2 = 20;
            blArray = new boolean[2];
            Instances instances = null;
            Clusterer clusterer = null;
            try {
                instances = this.makeTestDataset(42, n, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, bl6);
                if (bl && !bl6) {
                    instances.deleteAttributeAt(0);
                }
                if (n2 > 0) {
                    this.addMissing(instances, n2, bl7);
                }
                clusterer = Clusterer.makeCopies(this.getClusterer(), 1)[0];
            }
            catch (Exception exception) {
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                Instances instances2 = new Instances(instances);
                clusterer.buildClusterer(instances2);
                this.compareDatasets(instances, instances2);
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                this.println("no");
                blArray[0] = false;
                if (!this.m_Debug) break block6;
                this.println("\n=== Full Report ===");
                this.print("Problem during training");
                this.println(": " + exception.getMessage() + "\n");
                this.println("Here is the dataset:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
            }
        }
        return blArray;
    }

    protected boolean[] updatingEquality(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.print("incremental training produces the same results as batch training");
        this.printAttributeSummary(bl, bl2, bl3, bl4, bl5, bl6);
        this.print("...");
        int n = this.getNumInstances();
        int n2 = 0;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean[] blArray = new boolean[2];
        Instances instances = null;
        Clusterer[] clustererArray = null;
        ClusterEvaluation clusterEvaluation = null;
        ClusterEvaluation clusterEvaluation2 = null;
        boolean bl9 = false;
        try {
            instances = this.makeTestDataset(42, n, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, bl6);
            if (n2 > 0) {
                this.addMissing(instances, n2, bl7, bl8);
            }
            clustererArray = Clusterer.makeCopies(this.getClusterer(), 2);
            clusterEvaluation = new ClusterEvaluation();
            clusterEvaluation2 = new ClusterEvaluation();
            clustererArray[0].buildClusterer(instances);
            clusterEvaluation.setClusterer(clustererArray[0]);
        }
        catch (Exception exception) {
            throw new Error("Error setting up for tests: " + exception.getMessage());
        }
        try {
            clustererArray[1].buildClusterer(new Instances(instances, 0));
            for (int i = 0; i < instances.numInstances(); ++i) {
                ((UpdateableClusterer)((Object)clustererArray[1])).updateClusterer(instances.instance(i));
            }
            bl9 = true;
            clusterEvaluation2.setClusterer(clustererArray[1]);
            if (!clusterEvaluation.equals(clusterEvaluation2)) {
                this.println("no");
                blArray[0] = false;
                if (this.m_Debug) {
                    this.println("\n=== Full Report ===");
                    this.println("Results differ between batch and incrementally built models.\nDepending on the classifier, this may be OK");
                    this.println("Here are the results:\n");
                    this.println("\nbatch built results\n" + clusterEvaluation.clusterResultsToString());
                    this.println("\nincrementally built results\n" + clusterEvaluation2.clusterResultsToString());
                    this.println("Here are the datasets:\n");
                    this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
                }
            } else {
                this.println("yes");
                blArray[0] = true;
            }
        }
        catch (Exception exception) {
            blArray[0] = false;
            this.print("Problem during");
            if (bl9) {
                this.print(" testing");
            } else {
                this.print(" training");
            }
            this.println(": " + exception.getMessage() + "\n");
        }
        return blArray;
    }

    protected boolean[] runBasicTest(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7, int n2, FastVector fastVector) {
        boolean[] blArray;
        block10: {
            blArray = new boolean[2];
            Instances instances = null;
            Clusterer clusterer = null;
            try {
                instances = this.makeTestDataset(42, n2, bl ? this.getNumNominal() : 0, bl2 ? this.getNumNumeric() : 0, bl3 ? this.getNumString() : 0, bl4 ? this.getNumDate() : 0, bl5 ? this.getNumRelational() : 0, bl6);
                if (bl && !bl6) {
                    instances.deleteAttributeAt(0);
                }
                if (n > 0) {
                    this.addMissing(instances, n, bl7);
                }
                clusterer = Clusterer.makeCopies(this.getClusterer(), 1)[0];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("Error setting up for tests: " + exception.getMessage());
            }
            try {
                clusterer.buildClusterer(instances);
                this.println("yes");
                blArray[0] = true;
            }
            catch (Exception exception) {
                int n3;
                boolean bl8 = false;
                String string = exception.getMessage().toLowerCase();
                for (n3 = 0; n3 < fastVector.size(); ++n3) {
                    if (string.indexOf((String)fastVector.elementAt(n3)) < 0) continue;
                    bl8 = true;
                }
                this.println("no" + (bl8 ? " (OK error message)" : ""));
                blArray[1] = bl8;
                if (!this.m_Debug) break block10;
                this.println("\n=== Full Report ===");
                this.print("Problem during training");
                this.println(": " + exception.getMessage() + "\n");
                if (bl8) break block10;
                if (fastVector.size() > 0) {
                    this.print("Error message doesn't mention ");
                    for (n3 = 0; n3 < fastVector.size(); ++n3) {
                        if (n3 != 0) {
                            this.print(" or ");
                        }
                        this.print('\"' + (String)fastVector.elementAt(n3) + '\"');
                    }
                }
                this.println("here is the dataset:\n");
                this.println("=== Train Dataset ===\n" + instances.toString() + "\n");
            }
        }
        return blArray;
    }

    protected void addMissing(Instances instances, int n, boolean bl) {
        Random random = new Random(1L);
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            for (int j = 0; j < instances.numAttributes(); ++j) {
                if (!bl || Math.abs(random.nextInt()) % 100 >= n) continue;
                instance.setMissing(j);
            }
        }
    }

    protected Instances makeTestDataset(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) throws Exception {
        TestInstances testInstances = new TestInstances();
        testInstances.setSeed(n);
        testInstances.setNumInstances(n2);
        testInstances.setNumNominal(n3);
        testInstances.setNumNumeric(n4);
        testInstances.setNumString(n5);
        testInstances.setNumDate(n6);
        testInstances.setNumRelational(n7);
        testInstances.setClassIndex(-2);
        testInstances.setMultiInstance(bl);
        return testInstances.generate();
    }

    protected void printAttributeSummary(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        String string = "";
        if (bl2) {
            string = string + "numeric";
        }
        if (bl) {
            if (string.length() > 0) {
                string = string + " & ";
            }
            string = string + "nominal";
        }
        if (bl3) {
            if (string.length() > 0) {
                string = string + " & ";
            }
            string = string + "string";
        }
        if (bl4) {
            if (string.length() > 0) {
                string = string + " & ";
            }
            string = string + "date";
        }
        if (bl5) {
            if (string.length() > 0) {
                string = string + " & ";
            }
            string = string + "relational";
        }
        string = " (" + string + " predictors)";
        this.print(string);
    }

    public static void main(String[] stringArray) {
        CheckClusterer.runCheck(new CheckClusterer(), stringArray);
    }
}

