/*
 * Decompiled with CFR 0.152.
 */
package weka.core.parser.JFlex;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.core.parser.JFlex.Action;
import weka.core.parser.JFlex.CharClasses;
import weka.core.parser.JFlex.DFA;
import weka.core.parser.JFlex.ErrorMessages;
import weka.core.parser.JFlex.GeneratorException;
import weka.core.parser.JFlex.IntPair;
import weka.core.parser.JFlex.LexScan;
import weka.core.parser.JFlex.Macros;
import weka.core.parser.JFlex.Options;
import weka.core.parser.JFlex.Out;
import weka.core.parser.JFlex.RegExp;
import weka.core.parser.JFlex.RegExp1;
import weka.core.parser.JFlex.RegExp2;
import weka.core.parser.JFlex.RegExps;
import weka.core.parser.JFlex.StateSet;
import weka.core.parser.JFlex.StateSetEnumerator;

public final class NFA {
    StateSet[][] table;
    StateSet[] epsilon;
    boolean[] isFinal;
    boolean[] isPushback;
    Action[] action;
    int numStates;
    int numInput;
    int numLexStates;
    int estSize = 256;
    Macros macros;
    CharClasses classes;
    LexScan scanner;
    RegExps regExps;
    private static StateSetEnumerator states = new StateSetEnumerator();
    private static StateSet tempStateSet = new StateSet();
    private boolean[] live;
    private boolean[] visited;
    private int _end;
    private Vector _dfaStates;
    private int _dfaStart;

    public NFA(int n, int n2) {
        this.numInput = n;
        this.estSize = n2;
        this.numStates = 0;
        this.epsilon = new StateSet[n2];
        this.action = new Action[n2];
        this.isFinal = new boolean[n2];
        this.isPushback = new boolean[n2];
        this.table = new StateSet[n2][n];
    }

    public NFA(int n, LexScan lexScan, RegExps regExps, Macros macros, CharClasses charClasses) {
        this(n, regExps.NFASize(macros) + 2 * lexScan.states.number());
        this.scanner = lexScan;
        this.regExps = regExps;
        this.macros = macros;
        this.classes = charClasses;
        this.numLexStates = lexScan.states.number();
        this.ensureCapacity(2 * this.numLexStates);
        this.numStates = 2 * this.numLexStates;
    }

    public void addStandaloneRule() {
        int n;
        int n2 = this.numStates;
        int n3 = this.numStates + 1;
        for (n = 0; n < this.classes.getNumClasses(); ++n) {
            this.addTransition(n2, n, n3);
        }
        for (n = 0; n < this.numLexStates * 2; ++n) {
            this.addEpsilonTransition(n, n2);
        }
        this.action[n3] = new Action("System.out.print(yytext());", Integer.MAX_VALUE);
        this.isFinal[n3] = true;
    }

    public void addRegExp(int n) {
        IntPair intPair = this.insertNFA(this.regExps.getRegExp(n));
        Enumeration enumeration = this.regExps.getStates(n).elements();
        if (!enumeration.hasMoreElements()) {
            enumeration = this.scanner.states.getInclusiveStates();
        }
        while (enumeration.hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            if (!this.regExps.isBOL(n)) {
                this.addEpsilonTransition(2 * n2, intPair.start);
            }
            this.addEpsilonTransition(2 * n2 + 1, intPair.start);
        }
        if (this.regExps.getLookAhead(n) != null) {
            IntPair intPair2 = this.insertNFA(this.regExps.getLookAhead(n));
            this.addEpsilonTransition(intPair.end, intPair2.start);
            Action action = this.regExps.getAction(n);
            action.setLookAction(true);
            this.isPushback[intPair.end] = true;
            this.action[intPair2.end] = action;
            this.isFinal[intPair2.end] = true;
        } else {
            this.action[intPair.end] = this.regExps.getAction(n);
            this.isFinal[intPair.end] = true;
        }
    }

    private void ensureCapacity(int n) {
        int n2 = this.epsilon.length;
        if (n < n2) {
            return;
        }
        int n3 = Math.max(n2 * 2, n);
        boolean[] blArray = new boolean[n3];
        boolean[] blArray2 = new boolean[n3];
        Action[] actionArray = new Action[n3];
        StateSet[][] stateSetArray = new StateSet[n3][this.numInput];
        StateSet[] stateSetArray2 = new StateSet[n3];
        System.arraycopy(this.isFinal, 0, blArray, 0, this.numStates);
        System.arraycopy(this.isPushback, 0, blArray2, 0, this.numStates);
        System.arraycopy(this.action, 0, actionArray, 0, this.numStates);
        System.arraycopy(this.epsilon, 0, stateSetArray2, 0, this.numStates);
        System.arraycopy(this.table, 0, stateSetArray, 0, this.numStates);
        this.isFinal = blArray;
        this.isPushback = blArray2;
        this.action = actionArray;
        this.epsilon = stateSetArray2;
        this.table = stateSetArray;
    }

    public void addTransition(int n, int n2, int n3) {
        Out.debug("Adding transition (" + n + ", " + n2 + ", " + n3 + ")");
        int n4 = Math.max(n, n3) + 1;
        this.ensureCapacity(n4);
        if (n4 > this.numStates) {
            this.numStates = n4;
        }
        if (this.table[n][n2] != null) {
            this.table[n][n2].addState(n3);
        } else {
            this.table[n][n2] = new StateSet(this.estSize, n3);
        }
    }

    public void addEpsilonTransition(int n, int n2) {
        int n3 = Math.max(n, n2) + 1;
        this.ensureCapacity(n3);
        if (n3 > this.numStates) {
            this.numStates = n3;
        }
        if (this.epsilon[n] != null) {
            this.epsilon[n].addState(n2);
        } else {
            this.epsilon[n] = new StateSet(this.estSize, n2);
        }
    }

    private boolean containsFinal(StateSet stateSet) {
        states.reset(stateSet);
        while (states.hasMoreElements()) {
            if (!this.isFinal[states.nextElement()]) continue;
            return true;
        }
        return false;
    }

    private boolean containsPushback(StateSet stateSet) {
        states.reset(stateSet);
        while (states.hasMoreElements()) {
            if (!this.isPushback[states.nextElement()]) continue;
            return true;
        }
        return false;
    }

    private Action getAction(StateSet stateSet) {
        states.reset(stateSet);
        Action action = null;
        Out.debug("Determining action of : " + stateSet);
        while (states.hasMoreElements()) {
            Action action2 = this.action[states.nextElement()];
            if (action2 == null) continue;
            if (action == null) {
                action = action2;
                continue;
            }
            action = action.getHigherPriority(action2);
        }
        return action;
    }

    private StateSet closure(int n) {
        StateSet stateSet = tempStateSet;
        StateSet stateSet2 = new StateSet(this.numStates, n);
        stateSet.clear();
        stateSet.addState(n);
        while (stateSet.containsElements()) {
            int n2 = stateSet.getAndRemoveElement();
            stateSet.add(stateSet2.complement(this.epsilon[n2]));
            stateSet2.add(this.epsilon[n2]);
        }
        return stateSet2;
    }

    private StateSet closure(StateSet stateSet) {
        StateSet stateSet2 = new StateSet(this.numStates);
        if (stateSet != null) {
            states.reset(stateSet);
            while (states.hasMoreElements()) {
                stateSet2.add(this.closure(states.nextElement()));
            }
        }
        return stateSet2;
    }

    private void epsilonFill() {
        for (int i = 0; i < this.numStates; ++i) {
            this.epsilon[i] = this.closure(i);
        }
    }

    private StateSet DFAEdge(StateSet stateSet, char c) {
        tempStateSet.clear();
        states.reset(stateSet);
        while (states.hasMoreElements()) {
            tempStateSet.add(this.table[states.nextElement()][c]);
        }
        StateSet stateSet2 = new StateSet(tempStateSet);
        states.reset(tempStateSet);
        while (states.hasMoreElements()) {
            stateSet2.add(this.epsilon[states.nextElement()]);
        }
        return stateSet2;
    }

    public DFA getDFA() {
        StateSet stateSet;
        Hashtable<StateSet, Integer> hashtable = new Hashtable<StateSet, Integer>(this.numStates);
        Vector<StateSet> vector = new Vector<StateSet>(this.numStates);
        DFA dFA = new DFA(2 * this.numLexStates, this.numInput);
        int n = 0;
        int n2 = 0;
        Out.println("Converting NFA to DFA : ");
        this.epsilonFill();
        for (int i = 0; i < 2 * this.numLexStates; ++i) {
            stateSet = this.epsilon[i];
            hashtable.put(stateSet, new Integer(n));
            vector.addElement(stateSet);
            dFA.setLexState(i, n);
            dFA.setFinal(n, this.containsFinal(stateSet));
            dFA.setPushback(n, this.containsPushback(stateSet));
            dFA.setAction(n, this.getAction(stateSet));
            ++n;
        }
        --n;
        StateSet stateSet2 = tempStateSet;
        StateSetEnumerator stateSetEnumerator = states;
        stateSet = new StateSet(this.numStates);
        for (n2 = 0; n2 <= n; ++n2) {
            StateSet stateSet3 = (StateSet)vector.elementAt(n2);
            for (char c = '\u0000'; c < this.numInput; c = (char)((char)(c + 1))) {
                stateSet2.clear();
                stateSetEnumerator.reset(stateSet3);
                while (stateSetEnumerator.hasMoreElements()) {
                    stateSet2.add(this.table[stateSetEnumerator.nextElement()][c]);
                }
                stateSet.copy(stateSet2);
                stateSetEnumerator.reset(stateSet2);
                while (stateSetEnumerator.hasMoreElements()) {
                    stateSet.add(this.epsilon[stateSetEnumerator.nextElement()]);
                }
                if (!stateSet.containsElements()) continue;
                Integer n3 = (Integer)hashtable.get(stateSet);
                if (n3 != null) {
                    dFA.addTransition(n2, c, n3);
                    continue;
                }
                if (Options.progress) {
                    Out.print(".");
                }
                StateSet stateSet4 = new StateSet(stateSet);
                hashtable.put(stateSet4, new Integer(++n));
                vector.addElement(stateSet4);
                dFA.addTransition(n2, c, n);
                dFA.setFinal(n, this.containsFinal(stateSet4));
                dFA.setPushback(n, this.containsPushback(stateSet4));
                dFA.setAction(n, this.getAction(stateSet4));
            }
        }
        if (Options.verbose) {
            Out.println("");
        }
        return dFA;
    }

    public void dumpTable() {
        Out.dump(this.toString());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.numStates; ++i) {
            stringBuffer.append("State");
            if (this.isFinal[i]) {
                stringBuffer.append("[FINAL]");
            }
            if (this.isPushback[i]) {
                stringBuffer.append(" [PUSHBACK]");
            }
            stringBuffer.append(" " + i + Out.NL);
            for (int n = 0; n < this.numInput; n = (int)((char)(n + 1))) {
                if (this.table[i][n] == null || !this.table[i][n].containsElements()) continue;
                stringBuffer.append("  with " + n + " in " + this.table[i][n] + Out.NL);
            }
            if (this.epsilon[i] == null || !this.epsilon[i].containsElements()) continue;
            stringBuffer.append("  with epsilon in " + this.epsilon[i] + Out.NL);
        }
        return stringBuffer.toString();
    }

    public void writeDot(File file) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.println(this.dotFormat());
            printWriter.close();
        }
        catch (IOException iOException) {
            Out.error(ErrorMessages.FILE_WRITE, file);
            throw new GeneratorException();
        }
    }

    public String dotFormat() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digraph NFA {" + Out.NL);
        stringBuffer.append("rankdir = LR" + Out.NL);
        for (n = 0; n < this.numStates; ++n) {
            if (this.isFinal[n] || this.isPushback[n]) {
                stringBuffer.append(n);
            }
            if (this.isFinal[n]) {
                stringBuffer.append(" [shape = doublecircle]");
            }
            if (this.isPushback[n]) {
                stringBuffer.append(" [shape = box]");
            }
            if (!this.isFinal[n] && !this.isPushback[n]) continue;
            stringBuffer.append(Out.NL);
        }
        for (n = 0; n < this.numStates; ++n) {
            for (int i = 0; i < this.numInput; ++i) {
                if (this.table[n][i] == null) continue;
                StateSetEnumerator stateSetEnumerator = this.table[n][i].states();
                while (stateSetEnumerator.hasMoreElements()) {
                    int n2 = stateSetEnumerator.nextElement();
                    stringBuffer.append(n + " -> " + n2);
                    stringBuffer.append(" [label=\"" + this.classes.toString(i) + "\"]" + Out.NL);
                }
            }
            if (this.epsilon[n] == null) continue;
            StateSetEnumerator stateSetEnumerator = this.epsilon[n].states();
            while (stateSetEnumerator.hasMoreElements()) {
                int n3 = stateSetEnumerator.nextElement();
                stringBuffer.append(n + " -> " + n3 + " [style=dotted]" + Out.NL);
            }
        }
        stringBuffer.append("}" + Out.NL);
        return stringBuffer.toString();
    }

    private void insertLetterNFA(boolean bl, char c, int n, int n2) {
        if (bl) {
            int n3 = this.classes.getClassCode(Character.toLowerCase(c));
            int n4 = this.classes.getClassCode(Character.toUpperCase(c));
            this.addTransition(n, n3, n2);
            if (n4 != n3) {
                this.addTransition(n, n4, n2);
            }
        } else {
            this.addTransition(n, this.classes.getClassCode(c), n2);
        }
    }

    private IntPair insertStringNFA(boolean bl, String string) {
        int n;
        int n2 = this.numStates;
        for (n = 0; n < string.length(); ++n) {
            if (bl) {
                char c = string.charAt(n);
                int n3 = this.classes.getClassCode(Character.toLowerCase(c));
                int n4 = this.classes.getClassCode(Character.toUpperCase(c));
                this.addTransition(n + n2, n3, n + n2 + 1);
                if (n4 == n3) continue;
                this.addTransition(n + n2, n4, n + n2 + 1);
                continue;
            }
            this.addTransition(n + n2, this.classes.getClassCode(string.charAt(n)), n + n2 + 1);
        }
        return new IntPair(n2, n + n2);
    }

    private void insertClassNFA(Vector vector, int n, int n2) {
        if (vector == null) {
            return;
        }
        int[] nArray = this.classes.getClassCodes(vector);
        for (int i = 0; i < nArray.length; ++i) {
            this.addTransition(n, nArray[i], n2);
        }
    }

    private void insertNotClassNFA(Vector vector, int n, int n2) {
        int[] nArray = this.classes.getNotClassCodes(vector);
        for (int i = 0; i < nArray.length; ++i) {
            this.addTransition(n, nArray[i], n2);
        }
    }

    private IntPair complement(IntPair intPair) {
        int n;
        char c;
        StateSet stateSet;
        int n2 = intPair.end + 1;
        this.epsilonFill();
        Hashtable<StateSet, Integer> hashtable = new Hashtable<StateSet, Integer>(this.numStates);
        Vector<StateSet> vector = new Vector<StateSet>(this.numStates);
        int n3 = 0;
        int n4 = 0;
        StateSet stateSet2 = this.epsilon[intPair.start];
        hashtable.put(stateSet2, new Integer(n3));
        vector.addElement(stateSet2);
        for (n4 = 0; n4 <= n3; ++n4) {
            stateSet = (StateSet)vector.elementAt(n4);
            for (c = '\u0000'; c < this.numInput; c = (char)(c + '\u0001')) {
                stateSet2 = this.DFAEdge(stateSet, c);
                if (!stateSet2.containsElements()) continue;
                Integer n5 = (Integer)hashtable.get(stateSet2);
                if (n5 != null) {
                    this.addTransition(n2 + n4, c, n2 + n5);
                    continue;
                }
                if (Options.dump) {
                    Out.print("+");
                }
                hashtable.put(stateSet2, new Integer(++n3));
                vector.addElement(stateSet2);
                this.addTransition(n2 + n4, c, n2 + n3);
            }
        }
        c = n2 + n3 + 1;
        int n6 = n2 + n3 + 2;
        int n7 = n2 + n3 + 3;
        this.addEpsilonTransition(c, n2);
        for (n = 0; n < this.numInput; ++n) {
            this.addTransition(n6, n, n6);
        }
        this.addEpsilonTransition(n6, n7);
        for (n = 0; n <= n3; ++n) {
            stateSet = (StateSet)vector.elementAt(n);
            n4 = n2 + n;
            if (!stateSet.isElement(intPair.end)) {
                this.addEpsilonTransition(n4, n7);
            }
            for (int i = 0; i < this.numInput; ++i) {
                if (this.table[n4][i] != null) continue;
                this.addTransition(n4, i, n6);
            }
        }
        if (this.live == null || this.live.length < this.numStates) {
            this.live = new boolean[2 * this.numStates];
            this.visited = new boolean[2 * this.numStates];
        }
        this._end = n7;
        this._dfaStates = vector;
        this._dfaStart = n2;
        this.removeDead(n2);
        return new IntPair(c, n7);
    }

    private void removeDead(int n) {
        Object object;
        if (this.visited[n] || this.live[n]) {
            return;
        }
        this.visited[n] = true;
        if (this.closure(n).isElement(this._end)) {
            this.live[n] = true;
        }
        for (int i = 0; i < this.numInput; ++i) {
            object = this.closure(this.table[n][i]);
            StateSetEnumerator stateSetEnumerator = ((StateSet)object).states();
            while (stateSetEnumerator.hasMoreElements()) {
                int n2 = stateSetEnumerator.nextElement();
                if (n2 == n) continue;
                this.removeDead(n2);
                if (this.live[n2]) {
                    this.live[n] = true;
                    continue;
                }
                this.table[n][i] = null;
            }
        }
        StateSet stateSet = this.closure(this.epsilon[n]);
        object = stateSet.states();
        while (((StateSetEnumerator)object).hasMoreElements()) {
            int n3 = ((StateSetEnumerator)object).nextElement();
            if (n3 == n) continue;
            this.removeDead(n3);
            if (!this.live[n3]) continue;
            this.live[n] = true;
        }
    }

    private void insertNFA(RegExp regExp, int n, int n2) {
        switch (regExp.type) {
            case 34: {
                RegExp2 regExp2 = (RegExp2)regExp;
                this.insertNFA(regExp2.r1, n, n2);
                this.insertNFA(regExp2.r2, n, n2);
                return;
            }
            case 42: {
                this.insertClassNFA((Vector)((RegExp1)regExp).content, n, n2);
                return;
            }
            case 43: {
                this.insertNotClassNFA((Vector)((RegExp1)regExp).content, n, n2);
                return;
            }
            case 39: {
                this.insertLetterNFA(false, ((Character)((RegExp1)regExp).content).charValue(), n, n2);
                return;
            }
            case 46: {
                this.insertLetterNFA(true, ((Character)((RegExp1)regExp).content).charValue(), n, n2);
                return;
            }
            case 41: {
                this.insertNFA(this.macros.getDefinition((String)((RegExp1)regExp).content), n, n2);
                return;
            }
        }
        throw new Error("Unknown expression type " + regExp.type + " in NFA construction");
    }

    public IntPair insertNFA(RegExp regExp) {
        if (regExp.isCharClass(this.macros)) {
            int n = this.numStates;
            int n2 = this.numStates + 1;
            this.ensureCapacity(n2 + 1);
            if (n2 + 1 > this.numStates) {
                this.numStates = n2 + 1;
            }
            this.insertNFA(regExp, n, n2);
            return new IntPair(n, n2);
        }
        switch (regExp.type) {
            case 34: {
                RegExp2 regExp2 = (RegExp2)regExp;
                IntPair intPair = this.insertNFA(regExp2.r1);
                IntPair intPair2 = this.insertNFA(regExp2.r2);
                int n = intPair2.end + 1;
                int n3 = intPair2.end + 2;
                this.addEpsilonTransition(n, intPair.start);
                this.addEpsilonTransition(n, intPair2.start);
                this.addEpsilonTransition(intPair.end, n3);
                this.addEpsilonTransition(intPair2.end, n3);
                return new IntPair(n, n3);
            }
            case 44: {
                RegExp2 regExp2 = (RegExp2)regExp;
                IntPair intPair = this.insertNFA(regExp2.r1);
                IntPair intPair3 = this.insertNFA(regExp2.r2);
                this.addEpsilonTransition(intPair.end, intPair3.start);
                return new IntPair(intPair.start, intPair3.end);
            }
            case 32: {
                IntPair intPair = this.insertNFA((RegExp)((RegExp1)regExp).content);
                int n = intPair.end + 1;
                int n4 = intPair.end + 2;
                this.addEpsilonTransition(intPair.end, n4);
                this.addEpsilonTransition(n, intPair.start);
                this.addEpsilonTransition(n, n4);
                this.addEpsilonTransition(intPair.end, intPair.start);
                return new IntPair(n, n4);
            }
            case 33: {
                IntPair intPair = this.insertNFA((RegExp)((RegExp1)regExp).content);
                int n = intPair.end + 1;
                int n5 = intPair.end + 2;
                this.addEpsilonTransition(intPair.end, n5);
                this.addEpsilonTransition(n, intPair.start);
                this.addEpsilonTransition(intPair.end, intPair.start);
                return new IntPair(n, n5);
            }
            case 35: {
                IntPair intPair = this.insertNFA((RegExp)((RegExp1)regExp).content);
                this.addEpsilonTransition(intPair.start, intPair.end);
                return new IntPair(intPair.start, intPair.end);
            }
            case 37: {
                return this.complement(this.insertNFA((RegExp)((RegExp1)regExp).content));
            }
            case 38: {
                IntPair intPair = this.insertNFA((RegExp)((RegExp1)regExp).content);
                int n = intPair.end + 1;
                int n6 = n + 1;
                int n7 = n6 + 1;
                int n8 = n7 + 1;
                for (int i = 0; i < this.numInput; ++i) {
                    this.addTransition(n6, i, n6);
                    this.addTransition(n7, i, n7);
                }
                this.addEpsilonTransition(n, n6);
                this.addEpsilonTransition(n6, intPair.start);
                this.addEpsilonTransition(intPair.end, n7);
                this.addEpsilonTransition(n7, n8);
                intPair = this.complement(new IntPair(n, n8));
                IntPair intPair4 = this.insertNFA((RegExp)((RegExp1)regExp).content);
                this.addEpsilonTransition(intPair.end, intPair4.start);
                return new IntPair(intPair.start, intPair4.end);
            }
            case 40: {
                return this.insertStringNFA(false, (String)((RegExp1)regExp).content);
            }
            case 45: {
                return this.insertStringNFA(true, (String)((RegExp1)regExp).content);
            }
            case 41: {
                return this.insertNFA(this.macros.getDefinition((String)((RegExp1)regExp).content));
            }
        }
        throw new Error("Unknown expression type " + regExp.type + " in NFA construction");
    }
}

