/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class Reorder
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    protected Range m_NewOrderCols = new Range("first-last");
    protected int[] m_SelectedAttributes;
    protected int[] m_InputStringIndex;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSpecify list of columns to copy. First and last are valid\n\tindexes. (default first-last)", "R", 1, "-R <index1,index2-index4,...>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[2];
        int n = 0;
        if (!this.getAttributeIndices().equals("")) {
            stringArray[n++] = "-R";
            stringArray[n++] = this.getAttributeIndices();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        int n;
        super.setInputFormat(instances);
        this.m_NewOrderCols.setUpper(instances.numAttributes() - 1);
        Instances instances2 = new Instances(instances, 0);
        this.m_SelectedAttributes = this.m_NewOrderCols.getSelection();
        int n2 = 0;
        int[] nArray = new int[this.m_SelectedAttributes.length];
        for (n = 0; n < this.m_SelectedAttributes.length; ++n) {
            int n3 = this.m_SelectedAttributes[n];
            Attribute attribute = instances.attribute(n3);
            instances2.insertAttributeAt((Attribute)attribute.copy(), instances2.numAttributes());
            if (attribute.type() != 2) continue;
            nArray[n2++] = n3;
        }
        this.m_InputStringIndex = new int[n2];
        System.arraycopy(nArray, 0, this.m_InputStringIndex, 0, n2);
        instances2.setClassIndex(instances2.numAttributes() - 1);
        for (n = 0; n < instances.numAttributes(); ++n) {
            instances2.deleteAttributeAt(0);
        }
        this.setOutputFormat(instances2);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        double[] dArray = new double[this.outputFormatPeek().numAttributes()];
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            int n = this.m_SelectedAttributes[i];
            dArray[i] = instance.value(n);
        }
        Instance instance2 = null;
        instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        this.copyStringValues(instance2, false, instance.dataset(), this.m_InputStringIndex, this.getOutputFormat(), this.getOutputStringIndex());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
        return true;
    }

    public String globalInfo() {
        return "An instance filter that copies a range of attributes in the dataset. This is used in conjunction with other filters that overwrite attribute values during the course of their operation -- this filter allows the original attributes to be kept as well as the new attributes.";
    }

    public String getAttributeIndices() {
        return this.m_NewOrderCols.getRanges();
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public void setAttributeIndices(String string) throws Exception {
        this.m_NewOrderCols.setRanges(string);
    }

    public void setAttributeIndicesArray(int[] nArray) throws Exception {
        this.setAttributeIndices(Range.indicesToRangeList(nArray));
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new Reorder(), stringArray);
            } else {
                Filter.filterFile(new Reorder(), stringArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

