/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Queue;
import weka.core.RelationalLocator;
import weka.core.SerializedObject;
import weka.core.StringLocator;
import weka.core.Utils;

public abstract class Filter
implements Serializable {
    private Instances m_OutputFormat = null;
    private Queue m_OutputQueue = null;
    protected StringLocator m_OutputStringAtts = null;
    protected StringLocator m_InputStringAtts = null;
    protected RelationalLocator m_OutputRelAtts = null;
    protected RelationalLocator m_InputRelAtts = null;
    private Instances m_InputFormat = null;
    protected boolean m_NewBatch = true;

    protected void setOutputFormat(Instances instances) {
        if (instances != null) {
            this.m_OutputFormat = instances.stringFreeStructure();
            this.initOutputLocators(this.m_OutputFormat, null);
            String string = instances.relationName() + "-" + this.getClass().getName();
            if (this instanceof OptionHandler) {
                String[] stringArray = ((OptionHandler)((Object)this)).getOptions();
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i].trim();
                }
            }
            this.m_OutputFormat.setRelationName(string);
        } else {
            this.m_OutputFormat = null;
        }
        this.m_OutputQueue = new Queue();
    }

    protected Instances getInputFormat() {
        return this.m_InputFormat;
    }

    protected Instances inputFormatPeek() {
        return this.m_InputFormat;
    }

    protected Instances outputFormatPeek() {
        return this.m_OutputFormat;
    }

    protected void push(Instance instance) {
        if (instance != null) {
            if (instance.dataset() != null) {
                this.copyValues(instance, false);
            }
            instance.setDataset(this.m_OutputFormat);
            this.m_OutputQueue.push(instance);
        }
    }

    protected void resetQueue() {
        this.m_OutputQueue = new Queue();
    }

    protected void bufferInput(Instance instance) {
        if (instance != null) {
            this.copyValues(instance, true);
            this.m_InputFormat.add(instance);
        }
    }

    protected void initInputLocators(Instances instances, int[] nArray) {
        if (nArray == null) {
            this.m_InputStringAtts = new StringLocator(instances);
            this.m_InputRelAtts = new RelationalLocator(instances);
        } else {
            this.m_InputStringAtts = new StringLocator(instances, nArray);
            this.m_InputRelAtts = new RelationalLocator(instances, nArray);
        }
    }

    protected void initOutputLocators(Instances instances, int[] nArray) {
        if (nArray == null) {
            this.m_OutputStringAtts = new StringLocator(instances);
            this.m_OutputRelAtts = new RelationalLocator(instances);
        } else {
            this.m_OutputStringAtts = new StringLocator(instances, nArray);
            this.m_OutputRelAtts = new RelationalLocator(instances, nArray);
        }
    }

    protected void copyValues(Instance instance, boolean bl) {
        RelationalLocator.copyRelationalValues(instance, bl ? this.m_InputFormat : this.m_OutputFormat, bl ? this.m_InputRelAtts : this.m_OutputRelAtts);
        StringLocator.copyStringValues(instance, bl ? this.m_InputFormat : this.m_OutputFormat, bl ? this.m_InputStringAtts : this.m_OutputStringAtts);
    }

    protected void copyValues(Instance instance, boolean bl, Instances instances, Instances instances2) {
        RelationalLocator.copyRelationalValues(instance, bl, instances, this.m_InputRelAtts, instances2, this.m_OutputRelAtts);
        StringLocator.copyStringValues(instance, bl, instances, this.m_InputStringAtts, this.getOutputFormat(), this.m_OutputStringAtts);
    }

    protected void flushInput() {
        if (this.m_InputStringAtts.getAttributeIndices().length > 0 || this.m_InputRelAtts.getAttributeIndices().length > 0) {
            this.m_InputFormat = this.m_InputFormat.stringFreeStructure();
        } else {
            this.m_InputFormat.delete();
        }
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        this.m_InputFormat = instances.stringFreeStructure();
        this.m_OutputFormat = null;
        this.m_OutputQueue = new Queue();
        this.m_NewBatch = true;
        this.initInputLocators(instances, null);
        return false;
    }

    public Instances getOutputFormat() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output format defined.");
        }
        return new Instances(this.m_OutputFormat, 0);
    }

    public boolean input(Instance instance) throws Exception {
        if (this.m_InputFormat == null) {
            throw new NullPointerException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.m_OutputQueue = new Queue();
            this.m_NewBatch = false;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.m_InputFormat == null) {
            throw new NullPointerException("No input instance format defined");
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public Instance output() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output instance format defined");
        }
        if (this.m_OutputQueue.empty()) {
            return null;
        }
        Instance instance = (Instance)this.m_OutputQueue.pop();
        if (this.m_OutputQueue.empty() && this.m_NewBatch && (this.m_OutputStringAtts.getAttributeIndices().length > 0 || this.m_OutputRelAtts.getAttributeIndices().length > 0)) {
            this.m_OutputFormat = this.m_OutputFormat.stringFreeStructure();
        }
        return instance;
    }

    public Instance outputPeek() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output instance format defined");
        }
        if (this.m_OutputQueue.empty()) {
            return null;
        }
        Instance instance = (Instance)this.m_OutputQueue.peek();
        return instance;
    }

    public int numPendingOutput() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output instance format defined");
        }
        return this.m_OutputQueue.size();
    }

    public boolean isOutputFormatDefined() {
        return this.m_OutputFormat != null;
    }

    public static Filter makeCopy(Filter filter) throws Exception {
        return (Filter)new SerializedObject(filter).getObject();
    }

    public static Filter[] makeCopies(Filter filter, int n) throws Exception {
        if (filter == null) {
            throw new Exception("No model filter set");
        }
        Filter[] filterArray = new Filter[n];
        SerializedObject serializedObject = new SerializedObject(filter);
        for (int i = 0; i < filterArray.length; ++i) {
            filterArray[i] = (Filter)serializedObject.getObject();
        }
        return filterArray;
    }

    public static Instances useFilter(Instances instances, Filter filter) throws Exception {
        Instance instance;
        for (int i = 0; i < instances.numInstances(); ++i) {
            filter.input(instances.instance(i));
        }
        filter.batchFinished();
        Instances instances2 = filter.getOutputFormat();
        while ((instance = filter.output()) != null) {
            instances2.add(instance);
        }
        return instances2;
    }

    public static void filterFile(Filter filter, String[] stringArray) throws Exception {
        boolean bl = false;
        Instances instances = null;
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        try {
            boolean bl2 = Utils.getFlag('h', stringArray);
            if (Utils.getFlag('d', stringArray)) {
                bl = true;
            }
            String string = Utils.getOption('i', stringArray);
            String string2 = Utils.getOption('o', stringArray);
            String string3 = Utils.getOption('c', stringArray);
            if (filter instanceof OptionHandler) {
                ((OptionHandler)((Object)filter)).setOptions(stringArray);
            }
            Utils.checkForRemainingOptions(stringArray);
            if (bl2) {
                throw new Exception("Help requested.\n");
            }
            bufferedReader = string.length() != 0 ? new BufferedReader(new FileReader(string)) : new BufferedReader(new InputStreamReader(System.in));
            printWriter = string2.length() != 0 ? new PrintWriter(new FileOutputStream(string2)) : new PrintWriter(System.out);
            instances = new Instances(bufferedReader, 1);
            if (string3.length() != 0) {
                if (string3.equals("first")) {
                    instances.setClassIndex(0);
                } else if (string3.equals("last")) {
                    instances.setClassIndex(instances.numAttributes() - 1);
                } else {
                    instances.setClassIndex(Integer.parseInt(string3) - 1);
                }
            }
        }
        catch (Exception exception) {
            Object object;
            String string = "";
            if (filter instanceof OptionHandler) {
                string = string + "\nFilter options:\n\n";
                object = ((OptionHandler)((Object)filter)).listOptions();
                while (object.hasMoreElements()) {
                    Option option = (Option)object.nextElement();
                    string = string + option.synopsis() + '\n' + option.description() + "\n";
                }
            }
            object = "\nGeneral options:\n\n-h\n\tGet help on available options.\n\t(use -b -h for help on batch mode.)\n-i <file>\n\tThe name of the file containing input instances.\n\tIf not supplied then instances will be read from stdin.\n-o <file>\n\tThe name of the file output instances will be written to.\n\tIf not supplied then instances will be written to stdout.\n-c <class index>\n\tThe number of the attribute to use as the class.\n\t\"first\" and \"last\" are also valid entries.\n\tIf not supplied then no class is assigned.\n";
            throw new Exception('\n' + exception.getMessage() + string + (String)object);
        }
        if (bl) {
            System.err.println("Setting input format");
        }
        boolean bl3 = false;
        if (filter.setInputFormat(instances)) {
            if (bl) {
                System.err.println("Getting output format");
            }
            printWriter.println(filter.getOutputFormat().toString());
            bl3 = true;
        }
        while (instances.readInstance(bufferedReader)) {
            if (bl) {
                System.err.println("Input instance to filter");
            }
            if (filter.input(instances.instance(0))) {
                if (bl) {
                    System.err.println("Filter said collect immediately");
                }
                if (!bl3) {
                    throw new Error("Filter didn't return true from setInputFormat() earlier!");
                }
                if (bl) {
                    System.err.println("Getting output instance");
                }
                printWriter.println(filter.output().toString());
            }
            instances.delete(0);
        }
        if (bl) {
            System.err.println("Setting end of batch");
        }
        if (filter.batchFinished()) {
            if (bl) {
                System.err.println("Filter said collect output");
            }
            if (!bl3) {
                if (bl) {
                    System.err.println("Getting output format");
                }
                printWriter.println(filter.getOutputFormat().toString());
            }
            if (bl) {
                System.err.println("Getting output instance");
            }
            while (filter.numPendingOutput() > 0) {
                printWriter.println(filter.output().toString());
                if (!bl) continue;
                System.err.println("Getting output instance");
            }
        }
        if (bl) {
            System.err.println("Done");
        }
        if (printWriter != null) {
            printWriter.close();
        }
    }

    public static void batchFilterFile(Filter filter, String[] stringArray) throws Exception {
        Instances instances = null;
        Instances instances2 = null;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        try {
            boolean bl = Utils.getFlag('h', stringArray);
            String string = Utils.getOption('i', stringArray);
            if (string.length() == 0) {
                throw new Exception("No first input file given.\n");
            }
            bufferedReader = new BufferedReader(new FileReader(string));
            string = Utils.getOption('r', stringArray);
            if (string.length() == 0) {
                throw new Exception("No second input file given.\n");
            }
            bufferedReader2 = new BufferedReader(new FileReader(string));
            string = Utils.getOption('o', stringArray);
            printWriter = string.length() != 0 ? new PrintWriter(new FileOutputStream(string)) : new PrintWriter(System.out);
            string = Utils.getOption('s', stringArray);
            printWriter2 = string.length() != 0 ? new PrintWriter(new FileOutputStream(string)) : new PrintWriter(System.out);
            String string2 = Utils.getOption('c', stringArray);
            if (filter instanceof OptionHandler) {
                ((OptionHandler)((Object)filter)).setOptions(stringArray);
            }
            Utils.checkForRemainingOptions(stringArray);
            if (bl) {
                throw new Exception("Help requested.\n");
            }
            instances2 = new Instances(bufferedReader2, 1);
            instances = new Instances(bufferedReader, 1);
            if (!instances2.equalHeaders(instances)) {
                throw new Exception("Input file formats differ.\n");
            }
            if (string2.length() != 0) {
                if (string2.equals("first")) {
                    instances.setClassIndex(0);
                    instances2.setClassIndex(0);
                } else if (string2.equals("last")) {
                    instances.setClassIndex(instances.numAttributes() - 1);
                    instances2.setClassIndex(instances2.numAttributes() - 1);
                } else {
                    instances.setClassIndex(Integer.parseInt(string2) - 1);
                    instances2.setClassIndex(Integer.parseInt(string2) - 1);
                }
            }
        }
        catch (Exception exception) {
            Object object;
            String string = "";
            if (filter instanceof OptionHandler) {
                string = string + "\nFilter options:\n\n";
                object = ((OptionHandler)((Object)filter)).listOptions();
                while (object.hasMoreElements()) {
                    Option option = (Option)object.nextElement();
                    string = string + option.synopsis() + '\n' + option.description() + "\n";
                }
            }
            object = "\nGeneral options:\n\n-h\n\tGet help on available options.\n-i <filename>\n\tThe file containing first input instances.\n-o <filename>\n\tThe file first output instances will be written to.\n-r <filename>\n\tThe file containing second input instances.\n-s <filename>\n\tThe file second output instances will be written to.\n-c <class index>\n\tThe number of the attribute to use as the class.\n\t\"first\" and \"last\" are also valid entries.\n\tIf not supplied then no class is assigned.\n";
            throw new Exception('\n' + exception.getMessage() + string + (String)object);
        }
        boolean bl = false;
        if (filter.setInputFormat(instances)) {
            printWriter.println(filter.getOutputFormat().toString());
            bl = true;
        }
        while (instances.readInstance(bufferedReader)) {
            if (filter.input(instances.instance(0))) {
                if (!bl) {
                    throw new Error("Filter didn't return true from setInputFormat() earlier!");
                }
                printWriter.println(filter.output().toString());
            }
            instances.delete(0);
        }
        if (filter.batchFinished()) {
            if (!bl) {
                printWriter.println(filter.getOutputFormat().toString());
            }
            while (filter.numPendingOutput() > 0) {
                printWriter.println(filter.output().toString());
            }
        }
        if (printWriter != null) {
            printWriter.close();
        }
        bl = false;
        if (filter.isOutputFormatDefined()) {
            printWriter2.println(filter.getOutputFormat().toString());
            bl = true;
        }
        while (instances2.readInstance(bufferedReader2)) {
            if (filter.input(instances2.instance(0))) {
                if (!bl) {
                    throw new Error("Filter didn't return true from isOutputFormatDefined() earlier!");
                }
                printWriter2.println(filter.output().toString());
            }
            instances2.delete(0);
        }
        if (filter.batchFinished()) {
            if (!bl) {
                printWriter2.println(filter.getOutputFormat().toString());
            }
            while (filter.numPendingOutput() > 0) {
                printWriter2.println(filter.output().toString());
            }
        }
        if (printWriter2 != null) {
            printWriter2.close();
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception("First argument must be the class name of a Filter");
            }
            String string = stringArray[0];
            Filter filter = (Filter)Class.forName(string).newInstance();
            stringArray[0] = "";
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(filter, stringArray);
            } else {
                Filter.filterFile(filter, stringArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

