% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTestCase.R
\docType{methods}
\name{execCache}
\alias{execCache}
\alias{execCache,RTestCase-method}
\title{Execution Cache for Test Function}
\usage{
\S4method{execCache}{RTestCase}(object, tf.pkg, tf.pkg.i, tf.func,
  tf.func.i)
}
\arguments{
\item{object}{(\code{object}) The \code{\link{RTestCase-class}} object}

\item{tf.pkg}{(\code{character}) The package name of the currently executed test
function.}

\item{tf.pkg.i}{(\code{integer}) The package iteration number of the currently executed
test function.}

\item{tf.func}{(\code{character}) The function name of the currently executed test
function.}

\item{tf.func.i}{(\code{character}) The function iteration number of the currently
executed test function.}
}
\value{
(\code{list})
}
\description{
Creates the execution cache for the the currently executed test function.
}
\details{
The execution cache includes all cached results of test functions that are part of the same
package iteration and were executed prior to the current test function. The cached results will
be stored in as a list() object with the following format:\cr
\code{XML:                                        execCache:}\cr
\code{<pkg_01>}\cr
\code{  <func_01> ... </func_01>                    $funct_01}\cr
\code{  <func_01> ... </func_01>                    $funct_01[[1]]  -> result}\cr
\code{  <func_01> ... </func_01>                    $funct_01[[2]]  -> result}\cr
\code{  <func_02> ... </func_02>  <- current tf ->  $funct_02       -> result}\cr
\code{  <func_03> ... </func_03>                    --- not included ---}\cr
\code{</pkg_01>}
}
\seealso{
\code{\link{RTestCase-class}}
}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
