% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{inference}
\alias{inference}
\title{Inference from RTSA}
\usage{
inference(
  design,
  timing,
  ana_time,
  ma,
  fixed,
  conf_int = "sw",
  conf_level = 0.95,
  direction,
  tol = 1e-15
)
}
\arguments{
\item{design}{design}

\item{timing}{timing}

\item{ana_time}{analysis times}

\item{ma}{meta-analysis item}

\item{fixed}{Whether the analysis is fixed or random.}

\item{conf_int}{type of confidence interval}

\item{conf_level}{confidence interval level}

\item{direction}{whether the upper or lower boundary was crossed.}

\item{tol}{tolerance}
}
\value{
A data.frame of cumulative meta-analysis results including stopping boundaries and a list of conditional sequential inference to be parsed to RTSA
\item{results_df}{A data.frame containing information about: Cumulative test values, cumulative outcomes, timing of trials,
stopping boundaries (alpha_upper, alpha_lower, beta_upper, beta_lower), naive confidence intervals, TSA-adjusted confidence intervals,
cumulative p-values and standard deviations.}
\item{seq_inf}{If the meta-analysis crosses a alpha-spending boundary or a binding beta-spending boundary inference conditional on stopping is provided. A median unbiased estimate, lower and upper confidence interval, and p-value is provided based on stage-wise ordering.}
}
\description{
Naive inference, TSA-adjusted confidence intervals and stage-wise ordered inference if the meta-analysis crosses a alpha-spending boundary or a binding beta-spending boundary.
}
\examples{
ma <- metaanalysis(data = perioOxy, outcome = "RR", mc = 0.8)
sts <- ma$ris$NR_D2$NR_D2_full
timing <- cumsum(perioOxy$nI + perioOxy$nC)/sts
bound_oxy <- boundaries(timing = timing, alpha = 0.05, beta = 0.2, side = 2,
                       futility = "none", es_alpha = "esOF")
inference(timing = timing, design = bound_oxy, ma = ma, direction = -1, fixed = FALSE,
ana_time = 1:length(timing))

}
