% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exgauss.R
\name{exgauss}
\alias{exgauss}
\alias{dexgauss}
\alias{pexgauss}
\alias{qexgauss}
\alias{rexgauss}
\title{Exponentially modified Gaussian distribution}
\usage{
dexgauss(x, mu = 0, sigma = 1, lambda = 1, log = FALSE)

pexgauss(q, mu = 0, sigma = 1, lambda = 1, lower.tail = TRUE, log.p = FALSE)

qexgauss(p, mu = 0, sigma = 1, lambda = 1, lower.tail = TRUE, log.p = FALSE)

rexgauss(n, mu = 0, sigma = 1, lambda = 1)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{mean parameter of the Gaussian part}

\item{sigma}{standard deviation parameter of the Gaussian part, must be positive.}

\item{lambda}{rate parameter of the exponential part, must be positive.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of random values to return}
}
\value{
\code{dexgauss} gives the density, \code{pexgauss} gives the distribution function, \code{qexgauss} gives the quantile function, and \code{rexgauss} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the exponentially modified Gaussian distribution.
}
\details{
This implementation of \code{dexgauss} and \code{pexgauss} allows for automatic differentiation with \code{RTMB}.
\code{qexgauss} and \code{rexgauss} are reparameterised imports from \code{gamlss.dist::\link[gamlss.dist]{exGAUS}}.

If \eqn{X \sim N(\mu, \sigma^2)} and \eqn{Y \sim \text{Exp}(\lambda)}, then
\eqn{Z = X + Y} follows the exponentially modified Gaussian distribution with parameters \eqn{\mu}, \eqn{\sigma}, and \eqn{\lambda}.
}
\examples{
x <- rexgauss(1, 1, 2, 2)
d <- dexgauss(x, 1, 2, 2)
p <- pexgauss(x, 1, 2, 2)
q <- qexgauss(p, 1, 2, 2)
}
\references{
Rigby, R. A., Stasinopoulos, D. M., Heller, G. Z., and De Bastiani, F. (2019) Distributions for modeling location, scale, and shape: Using GAMLSS in R, Chapman and Hall/CRC,
doi:10.1201/9780429298547. An older version can be found in https://www.gamlss.com/.
}
