% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_repo_adapter.R
\name{repo_adapter_get_path}
\alias{repo_adapter_get_path}
\title{Returns adapter path related to project to use for dependencies resolution.}
\usage{
repo_adapter_get_path(repo_adapter, params, ix = NA)
}
\arguments{
\item{repo_adapter}{repo adapter object}

\item{params}{rsuite_project_params object}

\item{ix}{repo adapter index in project repositories or NA to retrieve all
paths for the adapter. (type: integer, default: NA)}
}
\value{
path to repository for the project.
}
\description{
Returns adapter path related to project to use for dependencies resolution.
}
\examples{
# create you own Repo adapter
repo_adapter_create_own <- function() {
  result <- repo_adapter_create_base("Own")
  class(result) <- c("repo_adapter_own", class(result))
  return(result)
}

#' @export
repo_adapter_get_path.repo_adapter_own <- function(repo_adapter, params, ix = NA) {
  # get arguments of the repo adapter specified in project PARAMETERS
  arg <- params$get_repo_adapter_arg(repo_adapter$name, default = "", ix = ix)
  url <- "https://..." # make url to repository base on arg
  return(url)
}

}
\seealso{
Other in extending RSuite with Repo adapter: \code{\link{repo_adapter_create_base}},
  \code{\link{repo_adapter_create_manager}},
  \code{\link{repo_adapter_get_info}},
  \code{\link{repo_manager_destroy}},
  \code{\link{repo_manager_get_info}},
  \code{\link{repo_manager_init}},
  \code{\link{repo_manager_remove}},
  \code{\link{repo_manager_upload}}
}
