% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_api_prj_config.R
\name{prj_config_set_repo_adapters}
\alias{prj_config_set_repo_adapters}
\title{Updates project configuration to use only specified repository adapters.}
\usage{
prj_config_set_repo_adapters(repos, prj = NULL)
}
\arguments{
\item{repos}{vector of repository adapters configuration to use by the project.
Each should be in form <repo_adapter_name>[<arg>]. They should be all
registered. (type: character)}

\item{prj}{project object to update configuration for. If not passed will use loaded
project or default whichever exists. Will init default project from working
directory if no default project exists. (type: rsuite_project, default: NULL)}
}
\description{
Updates project configuration to use only specified repository adapters.
}
\details{
Project configuration (together with repositories to be used) is stored in
PARAMETERS file in project folder.

After project configuration have been changed repository adapters are
initialized on the project.

Repository adapters will be used for dependencies detection in the same
order as passed in names.
}
\examples{
# create exemplary project base folder
prj_base <- tempfile("example_")
dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

# start project
prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

# present initial project configuration
cat(readLines(file.path(prj$path, "PARAMETERS")), sep = "\\n")

# set repositories to use
prj_config_set_repo_adapters(c("CRAN", "MRAN[2018-01-01]"), prj = prj)

# present final project configuration
cat(readLines(file.path(prj$path, "PARAMETERS")), sep = "\\n")

}
\seealso{
Other in project configuration: \code{\link{prj_config_set_rversion}}
}
