\name{rsaga.grid.calculus}
\alias{rsaga.grid.calculus}
\alias{rsaga.linear.combination}
\title{SAGA Module Grid Calculus}
\description{Perform Arithmetic Operations on Grids}
\usage{
rsaga.grid.calculus(in.grids, out.grid, formula, ...)
rsaga.linear.combination(in.grids, out.grid, 
        coef, cf.digits = 16, remove.zeros = FALSE, 
        remove.ones = TRUE, ...)
}
\arguments{
  \item{in.grids}{input character vector: SAGA grid files
        (default file extension: \code{.sgrd})}
  \item{out.grid}{output: grid file resulting from the cell-by-cell
        application of 'formula' to the grids.
        Existing files will be overwritten!}
  \item{formula}{character string of formula specifying the arithmetic
        operation to be performed on the \code{in.grids}
        (see Details); if this is a formula, only the right hand side
        will be used.}
  \item{coef}{numeric: coefficient vector to be used for the
        linear combination of the \code{in.grids}. If \code{coef}
        as one more element than \code{in.grids}, the first one
        will be interpreted as an intercept.}
  \item{cf.digits}{integer: number of digits used when converting
        the \code{coef}ficients to character strings
        (trailing zeros will be removed)}
  \item{remove.zeros}{logical: if \code{TRUE}, terms (grids) with
        coefficient (numerically) equal to zero (after rounding
        to \code{cf.digits} digits) will be removed from
        the formula}
  \item{remove.ones}{logical: if \code{TRUE} (default), factors
        equal to 1 (after rounding to \code{cf.digits} digits)
        will be removed from the formula}
  \item{\dots}{optional arguments to be passed to \code{\link{rsaga.geoprocessor}},
        including the \code{env} RSAGA geoprocessing environment}
}
\details{The \code{in.grids} are represented in the \code{formula}
by the letters \code{a} (for \code{in.grids[1]}), \code{b} etc.
Thus, if \code{in.grids[1]} is Landsat TM channel 3 and \code{in.grids[2]}
is channel 4, the NDVI formula (TM3-TM4)/(TM3+TM4) can be represented 
by the character string \code{"(a-b)/(a+b)"} (any spaces are removed)
or the formula \code{~(a-b)/(a+b)} in the \code{formula} argument.

In addition to +, -, *, and /, the following operators and 
functions are available for the \code{formula} definition:

    \item{\eqn{\hat{\ }}{^}}{power}
    \item{sin(a)}{sine}
    \item{cos(a)}{cosine}
    \item{tan(a)}{tangent}
    \item{asin(a)}{arc sine}
    \item{acos(a)}{arc cosine}
    \item{atan(a)}{arc tangent}
    \item{atan2(a,b)}{arc tangent of b/a}
    \item{abs(a)}{absolute value}
    \item{int(a)}{convert to integer}
    \item{sqrt(a)}{square root}
    \item{ln(a)}{natural logarithm}
    \item{mod(a,b)}{modulo}
    \item{gt(a, b)}{returns 1 if a greater b}
    \item{lt(a, b)}{returns 1 if a lower b}
    \item{eq(a, b)}{returns 1 if a equal b}
    \item{ifelse(switch, x, y)}{returns x if switch equals 1 else y}

Using \code{remove.zeros=FALSE} might have the side effect that no data
areas in the grid with coefficient 0 are passed on to the results
grid. (To be confirmed.)}
\value{The type of object returned depends on the \code{intern} argument
passed to the \code{\link{rsaga.geoprocessor}}. For \code{intern=FALSE}
it is a numerical error code (0: success), or otherwise (default)
a character vector with the module's console output.}
%\references{  }
\author{Alexander Brenning (R interface), Olaf Conrad (SAGA module)}
\note{This function uses module 1 in the SAGA library \code{grid_calculus}.}
\seealso{\code{\link{local.function}}, \code{\link{focal.function}},
and \code{\link{multi.focal.function}} for a more flexible framework for
combining grids or applying local and focal functions;
\code{\link{rsaga.geoprocessor}}, \code{\link{rsaga.env}}}
\examples{
\dontrun{
# using SAGA grids:
# calculate the NDVI from Landsat TM bands 3 and 4:
rsaga.grid.calculus(c("tm3.sgrd","tm4.sgrd"), "ndvi.sgrd", ~(a-b)/(a+b))
# apply a linear regression equation to grids:
coefs = c(20,-0.6)
# maybe from a linear regression of mean annual air temperature (MAAT)
# against elevation - something like:
# coefs = coef( lm( maat ~ elevation ) )
rsaga.linear.combination("elevation.sgrd", "maat.sgrd", coefs)
# equivalent:
rsaga.grid.calculus("elevation.sgrd", "maat.sgrd", ~ 20 - 0.6*a)
}}
\keyword{spatial}
\keyword{interface}
