% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{one_sided_test}
\alias{one_sided_test}
\title{One-sided testing}
\usage{
one_sided_test(tobs, tvals, alpha, tol = 1e-14)
}
\arguments{
\item{tobs}{The observed value of the test statistic (scalar).}

\item{tvals}{Vector of randomization values of the test statistic (to compare with \code{tobs}).}

\item{alpha}{Desired level of the test (between 0 to 1).}

\item{tol}{Used to check whether \code{tobs} is equal to the 1-\code{alpha} quantile of \code{tvals}.}
}
\value{
Test decision (binary).
}
\description{
Decides to reject or not based on observed test statistic value \code{tobs} and randomization values \code{tvals}.
}
\details{
The test may randomize to achieve the specified level \code{alpha}
when there are very few randomization values.
}
\seealso{
Testing Statistical Hypotheses (Ch. 15, Lehman and Romano, 2006)
}
