% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Boost.R
\name{Boost}
\alias{Boost}
\title{Robust Boosting for regression}
\usage{
Boost(
  x_train,
  y_train,
  x_val,
  y_val,
  x_test,
  y_test,
  type = "RRBoost",
  error = c("rmse", "aad"),
  niter = 200,
  y_init = "LADTree",
  max_depth = 1,
  tree_init_provided = NULL,
  control = Boost.control()
)
}
\arguments{
\item{x_train}{predictor matrix for training data (matrix/dataframe)}

\item{y_train}{response vector for training data (vector/dataframe)}

\item{x_val}{predictor matrix for validation data (matrix/dataframe)}

\item{y_val}{response vector for validation data (vector/dataframe)}

\item{x_test}{predictor matrix for test data (matrix/dataframe, optional, required when \code{make_prediction} in control is \code{TRUE})}

\item{y_test}{response vector for test data (vector/dataframe, optional, required when \code{make_prediction} in control is \code{TRUE})}

\item{type}{type of the boosting method: "L2Boost", "LADBoost", "MBoost", "Robloss", "SBoost", "RRBoost" (character string)}

\item{error}{a character string (or vector of character strings) indicating the type of error metrics to be evaluated on the test set. Valid options are: "rmse" (root mean squared error), "aad" (average absolute deviation), and "trmse" (trimmed root mean squared error)}

\item{niter}{number of boosting iterations (for RRBoost: T_{1,max} + T_{2,max}) (numeric)}

\item{y_init}{a string indicating the initial estimator to be used. Valid options are: "median" or "LADTree" (character string)}

\item{max_depth}{the maximum depth of the tree learners (numeric)}

\item{tree_init_provided}{an optional pre-fitted initial tree (an \code{rpart} object)}

\item{control}{a named list of control parameters, as returned by \code{\link{Boost.control}}}
}
\value{
A list with the following components:
\item{type}{which boosting algorithm was run. One of: "L2Boost", "LADBoost", "MBoost", "Robloss", "SBoost", "RRBoost" (character string)}
\item{control}{the list of control parameters used}
\item{niter}{number of iterations for the boosting algorithm (for RRBoost T_{1,max} + T_{2,max}) (numeric)}
\item{error}{if \code{make_prediction = TRUE} in argument \code{control}, a vector of prediction errors evaluated on the test set at early stopping time. The length of the vector matches that of the \code{error} argument in the input.}
\item{tree_init}{if \code{y_init = "LADTree"}, the initial tree (an object of class \code{rpart})}
\item{tree_list}{if \code{save_tree = TRUE} in \code{control}, a list of trees fitted at each boosting iteration}
\item{f_train_init}{a vector of the initialized estimator of the training data}
\item{alpha}{a vector of base learners' coefficients}
\item{early_stop_idx}{early stopping iteration}
\item{when_init}{if \code{type = "RRBoost"}, the early stopping time of the first stage of RRBoost}
\item{loss_train}{a vector of training loss values (one per iteration)}
\item{loss_val}{a vector of validation loss values (one per iteration)}
\item{err_val}{a vector of validation aad errors (one per iteration)}
\item{err_train}{a vector of training aad errors (one  per iteration)}
\item{err_test}{a matrix of test errors before and at the early stopping iteration (returned if make_prediction = TRUE in control); the matrix dimension is the early stopping iteration by the number of error types (matches the \code{error} argument in the input); each row corresponds to the test errors at each iteration}
\item{f_train}{a matrix of training function estimates at all iterations (returned if save_f = TRUE in control); each column corresponds to the fitted values of the predictor at each iteration}
\item{f_val}{a matrix of validation function estimates at all iterations (returned if save_f = TRUE in control); each column corresponds to the fitted values of the predictor at each iteration}
\item{f_test}{a matrix of test function estimatesbefore and at the early stopping iteration (returned if save_f = TRUE and make_prediction = TRUE in control); each column corresponds to the fitted values of the predictor at each iteration}
\item{var_select}{a vector of variable selection indicators (one  per explanatory variable; 1 if the variable was selected by at least one of the base learners, and 0 otherwise)}
\item{var_importance}{ a vector of permutation variable importance scores (one per explanatory variable, and returned if cal_imp = TRUE in control)}
}
\description{
This function implements the RRBoost robust boosting algorithm for regression,
as well as other robust and non-robust boosting algorithms for regression.
}
\details{
This function implements a robust boosting algorithm for regression (RRBoost).
It  also includes the following robust and non-robust boosting algorithms
for regression: L2Boost, LADBoost, MBoost, Robloss, and SBoost. This function
uses the functions available in the \code{rpart} package to construct binary regression trees.
}
\examples{
data(airfoil)
n <- nrow(airfoil)
n0 <- floor( 0.2 * n )
set.seed(123)
idx_test <- sample(n, n0)
idx_train <- sample((1:n)[-idx_test], floor( 0.6 * n ) )
idx_val <- (1:n)[ -c(idx_test, idx_train) ]
xx <- airfoil[, -6]
yy <- airfoil$y
xtrain <- xx[ idx_train, ]
ytrain <- yy[ idx_train ]
xval <- xx[ idx_val, ]
yval <- yy[ idx_val ]
xtest <- xx[ idx_test, ]
ytest <- yy[ idx_test ]
model_RRBoost_LADTree = Boost(x_train = xtrain, y_train = ytrain,
    x_val = xval, y_val = yval, x_test = xtest, y_test = ytest,
    type = "RRBoost", error = "rmse", y_init = "LADTree",
    max_depth = 1, niter = 10, ## to keep the running time low
    control = Boost.control(max_depth_init = 2,
    min_leaf_size_init = 20, make_prediction =  TRUE,
    cal_imp = FALSE))

}
\seealso{
\code{\link{Boost.validation}}, \code{\link{Boost.control}}.
}
\author{
Xiaomeng Ju, \email{xmengju@stat.ubc.ca}
}
