% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimatorSE.R
\name{EstimatorSE}
\alias{EstimatorSE}
\title{Wrapper Function for Standard Errors Estimates Functions}
\usage{
EstimatorSE(
  data,
  estimator.fun = c("DSR", "ES", "ESratio", "LPM", "Mean", "OmegaRatio", "RachevRatio",
    "robLoc", "SD", "SemiSD", "SR", "SoR", "VaR", "VaRratio")[1],
  se.method = c("IFiid", "IFcor", "IFcorAdapt", "IFcorPW", "BOOTiid", "BOOTcor")[1],
  cleanOutliers = FALSE,
  fitting.method = c("Exponential", "Gamma")[1],
  d.GLM.EN = 5,
  freq.include = c("All", "Decimate", "Truncate")[1],
  freq.par = 0.5,
  a = 0.3,
  b = 0.7,
  return.coef = FALSE,
  ...
)
}
\arguments{
\item{data}{Data of returns for one or multiple assets or portfolios.}

\item{estimator.fun}{Risk or performance measure to compute estimates of standard errors.}

\item{se.method}{A character string indicating which method should be used to compute
the standard error of the estimated standard deviation. One of:
\code{"IFiid"}, \code{"IFcor"}, \code{"IFcorAdapt"}, \code{"IFcorPW"},
\code{"BOOTiid"}, \code{"BOOTcor"}, or \code{"none"}.}

\item{cleanOutliers}{Boolean variable to indicate whether the pre-whitenning of the influence functions TS should be done through
a robust filter. Default if FALSE.}

\item{fitting.method}{Distribution used in the standard errors computation. Should be one of "Exponential" (default) or "Gamma".}

\item{d.GLM.EN}{Order of the polynomial for the Exponential or Gamma fitting. Default polynomial order of 5.}

\item{freq.include}{Frequency domain inclusion criteria. Must be one of "All" (default), "Decimate" or "Truncate."}

\item{freq.par}{Percentage of the frequency used if \code{"freq.include"} is "Decimate" or "Truncate." Default is 0.5.}

\item{a}{First adaptive method parameter.}

\item{b}{Second adaptive method parameter.}

\item{return.coef}{Boolean variable to indicate whether the coefficients of the Exponential or Gamma fit are returned. Default is FALSE.}

\item{...}{Additional parameters.}
}
\value{
A vector standard error estimates.
}
\description{
\code{EstimatorSE} computes the standard error for specified risk and performance measures.
}
\examples{
# Loading data
data(edhec)
# Changing the data colnames
names(edhec) = c("CA", "CTA", "DIS", "EM", "EMN",
                 "ED", "FIA", "GM", "LS", "MA",
                 "RV", "SS", "FOF")
# Computing the standard errors for
# the three influence functions based approaches
EstimatorSE(edhec[,"CA"], se.method = c("IFcor"),
            cleanOutliers = FALSE,
            fitting.method = c("Exponential", "Gamma")[1])

}
\author{
Xin Chen, \email{chenx26@uw.edu}

Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
