% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPM_SE.R
\name{LPM.SE}
\alias{LPM.SE}
\title{Standard Error Estimate for Lower Partial Moment (LPM) of Returns}
\usage{
LPM.SE(data, const = 0, k = 1, se.method = c("IFiid", "IFcor",
  "IFcorAdapt", "IFcorPW", "BOOTiid", "BOOTcor")[1:2],
  cleanOutliers = FALSE, fitting.method = c("Exponential", "Gamma")[1],
  ...)
}
\arguments{
\item{data}{Data of returns for one or multiple assets or portfolios.}

\item{const}{Constant threshold.}

\item{k}{Range parameter for the shape of the IF (the SD gets multiplied k times).}

\item{se.method}{A character string indicating which method should be used to compute
the standard error of the estimated standard deviation. One or a combination of:
\code{"IFiid"} (default), \code{"IFcor"} (default), \code{"IFcorPW"}, \code{"IFcorAdapt"},
\code{"BOOTiid"} or \code{"BOOTcor"}.}

\item{cleanOutliers}{Boolean variable to indicate whether the pre-whitenning of the influence functions TS should be done through a robust filter.}

\item{fitting.method}{Distribution used in the standard errors computation. Should be one of "Exponential" (default) or "Gamma".}

\item{...}{Additional parameters.}
}
\value{
A vector or a list depending on \code{se.method}.
}
\description{
\code{LPM.SE} computes the standard error of the LPM of the returns.
}
\examples{
# Loading data from PerformanceAnalytics
data(edhec, package = "PerformanceAnalytics")
class(edhec)
# Changing the data colnames
names(edhec) = c("CA", "CTA", "DIS", "EM", "EMN",
                 "ED", "FIA", "GM", "LS", "MA",
                 "RV", "SS", "FOF")
# Computing the standard errors for
# the two influence functions based approaches
LPM.SE(edhec, se.method=c("IFiid","IFcor"),
       cleanOutliers=FALSE,
       fitting.method=c("Exponential", "Gamma")[1])

}
\author{
Xin Chen, \email{chenx26@uw.edu}

Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
